/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm;

import android.graphics.Paint;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.events.MapListener;
import com.mapbox.mapboxsdk.events.RotateEvent;
import com.mapbox.mapboxsdk.events.ScrollEvent;
import com.mapbox.mapboxsdk.events.ZoomEvent;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.overlay.PathOverlay;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.MapViewListener;
import com.spatialdev.osm.events.OSMSelectionListener;
import com.spatialdev.osm.model.JTSModel;
import com.spatialdev.osm.model.OSMElement;
import com.spatialdev.osm.renderer.OSMOverlay;
import com.vividsolutions.jts.geom.Envelope;

public class OSMMap
implements MapViewListener,
MapListener {
    private static final boolean DEBUG = true;
    private MapView mapView;
    private JTSModel jtsModel;
    private OSMSelectionListener selectionListener;
    private OSMOverlay osmOverlay;
    private PathOverlay debugTapEnvelopePath;

    public OSMMap(MapView mapView, JTSModel jtsModel, OSMSelectionListener selectionListener) {
        this(mapView, jtsModel);
        this.selectionListener = selectionListener;
    }

    public OSMMap(MapView mapView, JTSModel jtsModel) {
        this.mapView = mapView;
        this.jtsModel = jtsModel;
        this.osmOverlay = new OSMOverlay(jtsModel);
        mapView.setMapViewListener(this);
        mapView.addListener(this);
        mapView.getOverlays().add(this.osmOverlay);
        mapView.invalidate();
    }

    public void setSelectionListener(OSMSelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    @Override
    public void onShowMarker(MapView pMapView, Marker pMarker) {
    }

    @Override
    public void onHideMarker(MapView pMapView, Marker pMarker) {
    }

    @Override
    public void onTapMarker(MapView pMapView, Marker pMarker) {
    }

    @Override
    public void onLongPressMarker(MapView pMapView, Marker pMarker) {
    }

    @Override
    public void onTapMap(MapView pMapView, ILatLng pPosition) {
        float zoom = pMapView.getZoomLevel();
        OSMElement.deselectAll();
        OSMElement element = this.jtsModel.queryFromTap(pPosition, zoom);
        if (element != null) {
            element.select();
        }
        this.drawDebugTapEnvelope(pMapView, pPosition, zoom);
        this.mapView.invalidate();
        if (OSMElement.hasSelectedElementsChanged() && this.selectionListener != null) {
            this.selectionListener.selectedElementsChanged(OSMElement.getSelectedElements());
        }
    }

    private void drawDebugTapEnvelope(MapView pMapView, ILatLng pPosition, float zoom) {
        PathOverlay path;
        Envelope env = this.jtsModel.createTapEnvelope(pPosition, zoom);
        if (this.debugTapEnvelopePath == null) {
            this.debugTapEnvelopePath = path = new PathOverlay();
            pMapView.getOverlays().add(path);
        } else {
            path = this.debugTapEnvelopePath;
        }
        Paint paint = path.getPaint();
        paint.setStrokeWidth(0.0f);
        paint.setARGB(200, 0, 255, 255);
        double maxX = env.getMaxX();
        double maxY = env.getMaxY();
        double minX = env.getMinX();
        double minY = env.getMinY();
        path.clearPath();
        path.addPoint(minY, minX);
        path.addPoint(maxY, minX);
        path.addPoint(maxY, maxX);
        path.addPoint(minY, maxX);
        path.addPoint(minY, minX);
    }

    @Override
    public void onLongPressMap(MapView pMapView, ILatLng pPosition) {
    }

    @Override
    public void onScroll(ScrollEvent event) {
        BoundingBox bbox = this.mapView.getBoundingBox();
        if (bbox != null) {
            this.osmOverlay.updateBoundingBox(bbox);
        }
    }

    @Override
    public void onZoom(ZoomEvent event) {
        BoundingBox bbox = this.mapView.getBoundingBox();
        if (bbox != null) {
            this.osmOverlay.updateBoundingBox(bbox);
        }
    }

    @Override
    public void onRotate(RotateEvent event) {
        BoundingBox bbox = this.mapView.getBoundingBox();
        if (bbox != null) {
            this.osmOverlay.updateBoundingBox(bbox);
        }
    }
}

