/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views.safecanvas;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.mapbox.mapboxsdk.views.safecanvas.ISafeCanvas;
import com.mapbox.mapboxsdk.views.safecanvas.SafePaint;
import com.mapbox.mapboxsdk.views.safecanvas.SafeTranslatedPath;

public class SafeTranslatedCanvas
extends Canvas
implements ISafeCanvas {
    private static final Matrix sMatrix = new Matrix();
    private static final RectF sRectF = new RectF();
    private static float[] sFloatAry = new float[0];
    private Canvas mCanvas;
    private final Matrix mMatrix = new Matrix();
    public int xOffset;
    public int yOffset;

    public SafeTranslatedCanvas() {
    }

    public SafeTranslatedCanvas(Canvas canvas) {
        this.setCanvas(canvas);
    }

    @Override
    public Canvas getSafeCanvas() {
        return this;
    }

    @Override
    public int getXOffset() {
        return this.xOffset;
    }

    @Override
    public int getYOffset() {
        return this.yOffset;
    }

    public void setCanvas(Canvas canvas) {
        this.mCanvas = canvas;
        canvas.getMatrix(this.mMatrix);
    }

    @Override
    public void getUnsafeCanvas(ISafeCanvas.UnsafeCanvasHandler handler) {
        this.save();
        this.setMatrix(this.getOriginalMatrix());
        handler.onUnsafeCanvas(this.mCanvas);
        this.restore();
    }

    @Override
    public Canvas getWrappedCanvas() {
        return this.mCanvas;
    }

    public Matrix getOriginalMatrix() {
        return this.mMatrix;
    }

    @Override
    public boolean clipPath(SafeTranslatedPath path, Region.Op op) {
        return this.getWrappedCanvas().clipPath((Path)path, op);
    }

    @Override
    public boolean clipPath(SafeTranslatedPath path) {
        return this.getWrappedCanvas().clipPath((Path)path);
    }

    @Override
    public boolean clipRect(double left, double top, double right, double bottom, Region.Op op) {
        return this.getWrappedCanvas().clipRect((float)(left + (double)this.xOffset), (float)(top + (double)this.yOffset), (float)(right + (double)this.xOffset), (float)(bottom + (double)this.yOffset), op);
    }

    @Override
    public boolean clipRect(double left, double top, double right, double bottom) {
        return this.getWrappedCanvas().clipRect((float)(left + (double)this.xOffset), (float)(top + (double)this.yOffset), (float)(right + (double)this.xOffset), (float)(bottom + (double)this.yOffset));
    }

    @Override
    public boolean clipRect(int left, int top, int right, int bottom) {
        return this.getWrappedCanvas().clipRect(left + this.xOffset, top + this.yOffset, right + this.xOffset, bottom + this.yOffset);
    }

    @Override
    public boolean clipRect(Rect rect, Region.Op op) {
        rect.offset(this.xOffset, this.yOffset);
        return this.getWrappedCanvas().clipRect(rect, op);
    }

    @Override
    public boolean clipRect(Rect rect) {
        rect.offset(this.xOffset, this.yOffset);
        return this.getWrappedCanvas().clipRect(rect);
    }

    @Override
    public boolean clipRegion(Region region, Region.Op op) {
        region.translate(this.xOffset, this.yOffset);
        return this.getWrappedCanvas().clipRegion(region, op);
    }

    @Override
    public boolean clipRegion(Region region) {
        region.translate(this.xOffset, this.yOffset);
        return this.getWrappedCanvas().clipRegion(region);
    }

    @Override
    public void concat(Matrix matrix) {
        this.getWrappedCanvas().concat(matrix);
    }

    @Override
    public void drawARGB(int a, int r, int g, int b) {
        this.getWrappedCanvas().drawARGB(a, r, g, b);
    }

    @Override
    public void drawArc(Rect oval, float startAngle, float sweepAngle, boolean useCenter, SafePaint paint) {
        this.getWrappedCanvas().drawArc(this.toOffsetRectF(oval, sRectF), startAngle, sweepAngle, useCenter, (Paint)paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, double left, double top, SafePaint paint) {
        this.getWrappedCanvas().drawBitmap(bitmap, (float)(left + (double)this.xOffset), (float)(top + (double)this.yOffset), (Paint)paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix, SafePaint paint) {
        sMatrix.set(matrix);
        sMatrix.postTranslate((float)this.xOffset, (float)this.yOffset);
        this.getWrappedCanvas().drawBitmap(bitmap, sMatrix, (Paint)paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, SafePaint paint) {
        dst.offset(this.xOffset, this.yOffset);
        this.getWrappedCanvas().drawBitmap(bitmap, src, dst, (Paint)paint);
        dst.offset(-this.xOffset, -this.yOffset);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        dst.offset(this.xOffset, this.yOffset);
        this.getWrappedCanvas().drawBitmap(bitmap, src, dst, paint);
        dst.offset(-this.xOffset, -this.yOffset);
    }

    @Override
    public void drawBitmap(int[] colors, int offset, int stride, double x, double y, int width, int height, boolean hasAlpha, SafePaint paint) {
        this.getWrappedCanvas().drawBitmap(colors, offset, stride, (float)(x + (double)this.xOffset), (float)(y + (double)this.yOffset), width, height, hasAlpha, (Paint)paint);
    }

    @Override
    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, SafePaint paint) {
        this.getWrappedCanvas().drawBitmap(colors, offset, stride, x + offset, y + offset, width, height, hasAlpha, (Paint)paint);
    }

    @Override
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, double[] verts, int vertOffset, int[] colors, int colorOffset, SafePaint paint) {
        this.getWrappedCanvas().drawBitmapMesh(bitmap, meshWidth, meshHeight, this.toOffsetFloatAry(verts, sFloatAry), vertOffset, colors, colorOffset, (Paint)paint);
    }

    @Override
    public void drawCircle(double cx, double cy, float radius, SafePaint paint) {
        this.getWrappedCanvas().drawCircle((float)(cx + (double)this.xOffset), (float)(cy + (double)this.yOffset), radius, (Paint)paint);
    }

    @Override
    public void drawColor(int color, PorterDuff.Mode mode) {
        this.getWrappedCanvas().drawColor(color, mode);
    }

    @Override
    public void drawColor(int color) {
        this.getWrappedCanvas().drawColor(color);
    }

    @Override
    public void drawLine(double startX, double startY, double stopX, double stopY, SafePaint paint) {
        this.getWrappedCanvas().drawLine((float)(startX += (double)this.xOffset), (float)(startY += (double)this.yOffset), (float)(stopX += (double)this.xOffset), (float)(stopY += (double)this.yOffset), (Paint)paint);
    }

    @Override
    public void drawLines(double[] pts, int offset, int count, SafePaint paint) {
        this.getWrappedCanvas().drawLines(this.toOffsetFloatAry(pts, sFloatAry), offset, count, (Paint)paint);
    }

    @Override
    public void drawLines(double[] pts, SafePaint paint) {
        this.getWrappedCanvas().drawLines(this.toOffsetFloatAry(pts, sFloatAry), (Paint)paint);
    }

    @Override
    public void drawOval(Rect oval, SafePaint paint) {
        this.getWrappedCanvas().drawOval(this.toOffsetRectF(oval, sRectF), (Paint)paint);
    }

    @Override
    public void drawPaint(SafePaint paint) {
        this.getWrappedCanvas().drawPaint((Paint)paint);
    }

    @Override
    public void drawPath(SafeTranslatedPath path, SafePaint paint) {
        this.getWrappedCanvas().drawPath((Path)path, (Paint)paint);
    }

    @Override
    public void drawPicture(Picture picture, Rect dst) {
        dst.offset(this.xOffset, this.yOffset);
        this.getWrappedCanvas().drawPicture(picture, dst);
        dst.offset(-this.xOffset, -this.yOffset);
    }

    @Override
    public void drawPicture(Picture picture) {
        this.getWrappedCanvas().drawPicture(picture);
    }

    @Override
    public void drawPoint(double x, double y, SafePaint paint) {
        this.getWrappedCanvas().drawPoint((float)(x += (double)this.xOffset), (float)(y += (double)this.yOffset), (Paint)paint);
    }

    @Override
    public void drawPoints(double[] pts, int offset, int count, SafePaint paint) {
        this.getWrappedCanvas().drawPoints(this.toOffsetFloatAry(pts, sFloatAry), offset, count, (Paint)paint);
    }

    @Override
    public void drawPoints(double[] pts, SafePaint paint) {
        this.getWrappedCanvas().drawPoints(this.toOffsetFloatAry(pts, sFloatAry), (Paint)paint);
    }

    @Override
    public void drawPosText(char[] text, int index, int count, double[] pos, SafePaint paint) {
        this.getWrappedCanvas().drawPosText(text, index, count, this.toOffsetFloatAry(pos, sFloatAry), (Paint)paint);
    }

    @Override
    public void drawPosText(String text, double[] pos, SafePaint paint) {
        this.getWrappedCanvas().drawPosText(text, this.toOffsetFloatAry(pos, sFloatAry), (Paint)paint);
    }

    @Override
    public void drawRGB(int r, int g, int b) {
        this.getWrappedCanvas().drawRGB(r, g, b);
    }

    @Override
    public void drawRect(double left, double top, double right, double bottom, SafePaint paint) {
        this.getWrappedCanvas().drawRect((float)(left += (double)this.xOffset), (float)(top += (double)this.yOffset), (float)(right += (double)this.xOffset), (float)(bottom += (double)this.yOffset), (Paint)paint);
    }

    @Override
    public void drawRect(Rect r, SafePaint paint) {
        r.offset(this.xOffset, this.yOffset);
        this.getWrappedCanvas().drawRect(r, (Paint)paint);
        r.offset(-this.xOffset, -this.yOffset);
    }

    @Override
    public void drawRoundRect(Rect rect, float rx, float ry, SafePaint paint) {
        this.getWrappedCanvas().drawRoundRect(this.toOffsetRectF(rect, sRectF), rx, ry, (Paint)paint);
    }

    @Override
    public void drawText(String text, double x, double y, SafePaint paint) {
        this.getWrappedCanvas().drawText(text, (float)(x + (double)this.xOffset), (float)(y + (double)this.yOffset), (Paint)paint);
    }

    public void drawText(String text, float x, float y, Paint paint) {
        this.getWrappedCanvas().drawText(text, x + (float)this.xOffset, y + (float)this.yOffset, paint);
    }

    @Override
    public void drawText(char[] text, int index, int count, double x, double y, SafePaint paint) {
        this.getWrappedCanvas().drawText(text, index, count, (float)(x + (double)this.xOffset), (float)(y + (double)this.yOffset), (Paint)paint);
    }

    @Override
    public void drawText(CharSequence text, int start, int end, double x, double y, SafePaint paint) {
        this.getWrappedCanvas().drawText(text, start, end, (float)(x + (double)this.xOffset), (float)(y + (double)this.yOffset), (Paint)paint);
    }

    @Override
    public void drawText(String text, int start, int end, double x, double y, SafePaint paint) {
        this.getWrappedCanvas().drawText(text, start, end, (float)(x + (double)this.xOffset), (float)(y + (double)this.yOffset), (Paint)paint);
    }

    @Override
    public void drawTextOnPath(char[] text, int index, int count, SafeTranslatedPath path, float hOffset, float vOffset, SafePaint paint) {
        this.getWrappedCanvas().drawTextOnPath(text, index, count, (Path)path, hOffset, vOffset, (Paint)paint);
    }

    @Override
    public void drawTextOnPath(String text, SafeTranslatedPath path, float hOffset, float vOffset, SafePaint paint) {
        this.getWrappedCanvas().drawTextOnPath(text, (Path)path, hOffset, vOffset, (Paint)paint);
    }

    @Override
    public void drawVertices(Canvas.VertexMode mode, int vertexCount, double[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, SafePaint paint) {
        this.getWrappedCanvas().drawVertices(mode, vertexCount, this.toOffsetFloatAry(verts, sFloatAry), vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, (Paint)paint);
    }

    @Override
    public boolean getClipBounds(Rect bounds) {
        boolean success = this.getWrappedCanvas().getClipBounds(bounds);
        if (bounds != null) {
            bounds.offset(-this.xOffset, -this.yOffset);
        }
        return success;
    }

    @Override
    public int getDensity() {
        return this.getWrappedCanvas().getDensity();
    }

    @Override
    public DrawFilter getDrawFilter() {
        return this.getWrappedCanvas().getDrawFilter();
    }

    @Override
    public int getHeight() {
        return this.getWrappedCanvas().getHeight();
    }

    @Override
    public void getMatrix(Matrix ctm) {
        this.getWrappedCanvas().getMatrix(ctm);
    }

    @Override
    public int getSaveCount() {
        return this.getWrappedCanvas().getSaveCount();
    }

    @Override
    public int getWidth() {
        return this.getWrappedCanvas().getWidth();
    }

    @Override
    public boolean isOpaque() {
        return this.getWrappedCanvas().isOpaque();
    }

    @Override
    public boolean quickReject(double left, double top, double right, double bottom, Canvas.EdgeType type) {
        return this.getWrappedCanvas().quickReject((float)(left += (double)this.xOffset), (float)(top += (double)this.yOffset), (float)(right += (double)this.xOffset), (float)(bottom += (double)this.yOffset), type);
    }

    @Override
    public boolean quickReject(SafeTranslatedPath path, Canvas.EdgeType type) {
        return this.getWrappedCanvas().quickReject((Path)path, type);
    }

    @Override
    public boolean quickReject(Rect rect, Canvas.EdgeType type) {
        return this.getWrappedCanvas().quickReject(this.toOffsetRectF(rect, sRectF), type);
    }

    @Override
    public void restore() {
        this.getWrappedCanvas().restore();
    }

    @Override
    public void restoreToCount(int saveCount) {
        this.getWrappedCanvas().restoreToCount(saveCount);
    }

    @Override
    public void rotate(float degrees) {
        this.getWrappedCanvas().translate((float)this.xOffset, (float)this.yOffset);
        this.getWrappedCanvas().rotate(degrees);
        this.getWrappedCanvas().translate((float)(-this.xOffset), (float)(-this.yOffset));
    }

    @Override
    public void rotate(float degrees, double px, double py) {
        this.getWrappedCanvas().rotate(degrees, (float)(px + (double)this.xOffset), (float)(py + (double)this.yOffset));
    }

    @Override
    public int save() {
        return this.getWrappedCanvas().save();
    }

    @Override
    public int save(int saveFlags) {
        return this.getWrappedCanvas().save(saveFlags);
    }

    @Override
    public int saveLayer(double left, double top, double right, double bottom, SafePaint paint, int saveFlags) {
        return this.getWrappedCanvas().saveLayer((float)(left + (double)this.xOffset), (float)(top + (double)this.yOffset), (float)(right + (double)this.xOffset), (float)(bottom + (double)this.yOffset), (Paint)paint, saveFlags);
    }

    @Override
    public int saveLayer(Rect bounds, SafePaint paint, int saveFlags) {
        int result = this.getWrappedCanvas().saveLayer(this.toOffsetRectF(bounds, sRectF), (Paint)paint, saveFlags);
        return result;
    }

    @Override
    public int saveLayerAlpha(double left, double top, double right, double bottom, int alpha, int saveFlags) {
        return this.getWrappedCanvas().saveLayerAlpha((float)(left + (double)this.xOffset), (float)(top + (double)this.yOffset), (float)(right + (double)this.xOffset), (float)(bottom + (double)this.yOffset), alpha, saveFlags);
    }

    @Override
    public int saveLayerAlpha(Rect bounds, int alpha, int saveFlags) {
        return this.getWrappedCanvas().saveLayerAlpha(this.toOffsetRectF(bounds, sRectF), alpha, saveFlags);
    }

    @Override
    public void scale(float sx, float sy) {
        this.getWrappedCanvas().scale(sx, sy);
    }

    @Override
    public void scale(float sx, float sy, double px, double py) {
        this.getWrappedCanvas().scale(sx, sy, (float)(px + (double)this.xOffset), (float)(py + (double)this.yOffset));
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        this.getWrappedCanvas().setBitmap(bitmap);
    }

    @Override
    public void setDensity(int density) {
        this.getWrappedCanvas().setDensity(density);
    }

    @Override
    public void setDrawFilter(DrawFilter filter) {
        this.getWrappedCanvas().setDrawFilter(filter);
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.getWrappedCanvas().setMatrix(matrix);
    }

    @Override
    public void skew(float sx, float sy) {
        this.getWrappedCanvas().skew(sx, sy);
    }

    @Override
    public void translate(float dx, float dy) {
        this.getWrappedCanvas().translate(dx, dy);
    }

    public boolean equals(Object o) {
        return this.getWrappedCanvas().equals(o);
    }

    public int hashCode() {
        return this.getWrappedCanvas().hashCode();
    }

    public String toString() {
        return this.getWrappedCanvas().toString();
    }

    protected final RectF toOffsetRectF(Rect rect, RectF reuse) {
        if (reuse == null) {
            reuse = new RectF();
        }
        reuse.set((float)(rect.left + this.xOffset), (float)(rect.top + this.yOffset), (float)(rect.right + this.xOffset), (float)(rect.bottom + this.yOffset));
        return reuse;
    }

    protected final float[] toOffsetFloatAry(double[] rect, float[] reuse) {
        if (reuse == null || reuse.length < rect.length) {
            reuse = new float[rect.length];
        }
        for (int a = 0; a < rect.length; ++a) {
            reuse[a] = (float)(rect[a] + (double)(a % 2 == 0 ? this.xOffset : this.yOffset));
        }
        return reuse;
    }
}

