/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;

public class Position
implements Parcelable {
    private static final int LON_IDX = 0;
    private static final int LAT_IDX = 1;
    private static final int ALT_IDX = 2;
    private final double[] mStorage = new double[3];
    public static final Parcelable.Creator<Position> CREATOR = new Parcelable.Creator<Position>(){

        public Position createFromParcel(Parcel in) {
            return new Position(in);
        }

        public Position[] newArray(int size) {
            return new Position[size];
        }
    };

    public Position(JSONArray array) {
        this.mStorage[0] = array.optDouble(0, 0.0);
        this.mStorage[1] = array.optDouble(1, 0.0);
        this.mStorage[2] = array.optDouble(2, 0.0);
    }

    public Position(double[] array) {
        if (array.length == 2) {
            this.mStorage[0] = array[0];
            this.mStorage[1] = array[1];
        } else if (array.length == 3) {
            this.mStorage[0] = array[0];
            this.mStorage[1] = array[1];
            this.mStorage[2] = array[2];
        }
    }

    public Position(double latitude, double longitude) {
        this.mStorage[1] = latitude;
        this.mStorage[0] = longitude;
    }

    public Position(double latitude, double longitude, double altitude) {
        this.mStorage[1] = latitude;
        this.mStorage[0] = longitude;
        this.mStorage[2] = altitude;
    }

    public Position(Location location) {
        this.mStorage[1] = location.getLatitude();
        this.mStorage[0] = location.getLongitude();
        this.mStorage[2] = location.getAltitude();
    }

    private Position(Parcel parcel) {
        this(parcel.createDoubleArray());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDoubleArray(this.mStorage);
    }

    public double getLatitude() {
        return this.mStorage[1];
    }

    public void setLatitude(double latitude) {
        this.mStorage[1] = latitude;
    }

    public double getLongitude() {
        return this.mStorage[0];
    }

    public void setLongitude(double longitude) {
        this.mStorage[0] = longitude;
    }

    public double getAltitude() {
        return this.mStorage[2];
    }

    public void setAltitude(double altitude) {
        this.mStorage[2] = altitude;
    }

    public JSONArray toJSON() throws JSONException {
        JSONArray coordinates = new JSONArray();
        coordinates.put(1, this.getLatitude());
        coordinates.put(0, this.getLongitude());
        coordinates.put(2, this.getAltitude());
        return coordinates;
    }

    public Location toLocation() {
        Location location = new Location("GeoJSON");
        location.setLatitude(this.getLatitude());
        location.setLongitude(this.getLongitude());
        location.setAltitude(this.getAltitude());
        return location;
    }

    public double[] toArray() {
        return this.mStorage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Position)) {
            return false;
        }
        Position aPosition = (Position)object;
        return Arrays.equals(this.mStorage, aPosition.mStorage);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mStorage);
    }

    public String toString() {
        return Arrays.toString(this.mStorage);
    }
}

