/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.constants.GeoConstants;
import com.mapbox.mapboxsdk.constants.MathConstants;
import java.io.Serializable;

public final class LatLng
implements ILatLng,
GeoConstants,
MathConstants,
Parcelable,
Serializable {
    private double longitude;
    private double latitude;
    private double altitude = 0.0;
    public static final Parcelable.Creator<LatLng> CREATOR = new Parcelable.Creator<LatLng>(){

        public LatLng createFromParcel(Parcel in) {
            return new LatLng(in);
        }

        public LatLng[] newArray(int size) {
            return new LatLng[size];
        }
    };

    public LatLng(double aLatitude, double aLongitude) {
        this.latitude = aLatitude;
        this.longitude = aLongitude;
    }

    public LatLng(double aLatitude, double aLongitude, double aAltitude) {
        this.latitude = aLatitude;
        this.longitude = aLongitude;
        this.altitude = aAltitude;
    }

    public LatLng(Location aLocation) {
        this(aLocation.getLatitude(), aLocation.getLongitude(), aLocation.getAltitude());
    }

    public LatLng(LatLng aLatLng) {
        this.latitude = aLatLng.latitude;
        this.longitude = aLatLng.longitude;
        this.altitude = aLatLng.altitude;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double getAltitude() {
        return this.altitude;
    }

    public String toString() {
        return this.latitude + "," + this.longitude + "," + this.altitude;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        LatLng rhs = (LatLng)obj;
        return rhs.latitude == this.latitude && rhs.longitude == this.longitude && rhs.altitude == this.altitude;
    }

    public int hashCode() {
        return (int)(37.0 * (17.0 * this.latitude * 1000000.0 + this.longitude * 1000000.0) + this.altitude);
    }

    private LatLng(Parcel in) {
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.altitude = in.readDouble();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.latitude);
        out.writeDouble(this.longitude);
        out.writeDouble(this.altitude);
    }

    public int distanceTo(LatLng other) {
        double a1 = 0.01745329238474369 * this.latitude;
        double a2 = 0.01745329238474369 * this.longitude;
        double b1 = 0.01745329238474369 * other.getLatitude();
        double b2 = 0.01745329238474369 * other.getLongitude();
        double cosa1 = Math.cos(a1);
        double cosb1 = Math.cos(b1);
        double t1 = cosa1 * Math.cos(a2) * cosb1 * Math.cos(b2);
        double t2 = cosa1 * Math.sin(a2) * cosb1 * Math.sin(b2);
        double t3 = Math.sin(a1) * Math.sin(b1);
        double tt = Math.acos(t1 + t2 + t3);
        return (int)(6378137.0 * tt);
    }
}

