/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.offline.OfflineDatabaseHandler;
import java.util.Hashtable;

public class OfflineDatabaseManager {
    private static OfflineDatabaseManager offlineDatabaseManager = null;
    private Hashtable<String, OfflineDatabaseHandler> databaseHandlers = new Hashtable();
    private static Context context = null;

    private OfflineDatabaseManager() {
    }

    public static OfflineDatabaseManager getOfflineDatabaseManager(Context ctx) {
        if (offlineDatabaseManager == null) {
            offlineDatabaseManager = new OfflineDatabaseManager();
        }
        context = ctx;
        return offlineDatabaseManager;
    }

    public OfflineDatabaseHandler getOfflineDatabaseHandlerForMapId(String mapId) {
        if (this.databaseHandlers.containsKey(mapId.toLowerCase())) {
            return this.databaseHandlers.get(mapId);
        }
        OfflineDatabaseHandler dbh = new OfflineDatabaseHandler(context, mapId.toLowerCase() + "-PARTIAL");
        this.databaseHandlers.put(mapId.toLowerCase(), dbh);
        return dbh;
    }

    public OfflineDatabaseHandler getOfflineDatabaseHandlerForMapId(String mapId, boolean fromFileSystem) {
        if (!fromFileSystem) {
            return this.getOfflineDatabaseHandlerForMapId(mapId);
        }
        String key = mapId.toLowerCase();
        if (this.databaseHandlers.containsKey(key)) {
            return this.databaseHandlers.get(key);
        }
        OfflineDatabaseHandler dbh = new OfflineDatabaseHandler(context, key);
        this.databaseHandlers.put(key, dbh);
        return dbh;
    }

    public boolean switchHandlerFromPartialToRegular(String mapId) {
        if (TextUtils.isEmpty((CharSequence)mapId)) {
            return false;
        }
        String key = mapId.toLowerCase();
        if (!this.databaseHandlers.containsKey(key)) {
            return false;
        }
        OfflineDatabaseHandler dbh = new OfflineDatabaseHandler(context, key);
        this.databaseHandlers.remove(key);
        this.databaseHandlers.put(key, dbh);
        return true;
    }
}

