/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import android.graphics.drawable.Drawable;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.constants.TileLayerConstants;
import com.mapbox.mapboxsdk.tileprovider.modules.MapTileDownloader;
import com.mapbox.mapboxsdk.tileprovider.tilesource.ITileLayer;
import com.mapbox.mapboxsdk.views.util.constants.MapViewConstants;

public class TileLayer
implements ITileLayer,
TileLayerConstants,
MapViewConstants {
    protected String mUrl;
    protected String mCacheKey;
    protected String mName;
    protected String mDescription;
    protected String mAttribution;
    protected String mLegend;
    protected float mMinimumZoomLevel = 0.0f;
    protected float mMaximumZoomLevel = 22.0f;
    protected BoundingBox mBoundingBox = WORLD_BOUNDING_BOX;
    protected LatLng mCenter = new LatLng(0.0, 0.0);
    private final int mTileSizePixels = 256;

    public TileLayer(String pId, String aUrl) {
        this.mUrl = aUrl;
        this.mCacheKey = pId;
    }

    @Override
    public TileLayer setURL(String aUrl) {
        this.mUrl = aUrl;
        return this;
    }

    public TileLayer setAttribution(String aAttribution) {
        this.mAttribution = aAttribution;
        return this;
    }

    public TileLayer setDescription(String aDescription) {
        this.mDescription = aDescription;
        return this;
    }

    public TileLayer setName(String aName) {
        this.mName = aName;
        return this;
    }

    public TileLayer setMinimumZoomLevel(float aMinimumZoomLevel) {
        this.mMinimumZoomLevel = aMinimumZoomLevel;
        return this;
    }

    public TileLayer setMaximumZoomLevel(float aMaximumZoomLevel) {
        this.mMaximumZoomLevel = aMaximumZoomLevel;
        return this;
    }

    @Override
    public Drawable getDrawableFromTile(MapTileDownloader downloader, MapTile aTile, boolean hdpi) {
        return null;
    }

    @Override
    public void detach() {
    }

    @Override
    public float getMinimumZoomLevel() {
        return this.mMinimumZoomLevel;
    }

    @Override
    public float getMaximumZoomLevel() {
        return this.mMaximumZoomLevel;
    }

    @Override
    public int getTileSizePixels() {
        return 256;
    }

    @Override
    public String getCacheKey() {
        return this.mCacheKey;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.mBoundingBox;
    }

    @Override
    public LatLng getCenterCoordinate() {
        return this.mCenter;
    }

    @Override
    public float getCenterZoom() {
        if (this.mCenter != null) {
            return (float)this.mCenter.getAltitude();
        }
        return Math.round(this.mMaximumZoomLevel + this.mMinimumZoomLevel) / 2;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public String getAttribution() {
        return this.mAttribution;
    }

    @Override
    public String getLegend() {
        return this.mLegend;
    }
}

