/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.util.Log;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.constants.TileLayerConstants;
import com.mapbox.mapboxsdk.util.BitmapUtils;
import java.io.File;
import java.io.InputStream;
import uk.co.senab.bitmapcache.BitmapLruCache;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class MapTileCache
implements TileLayerConstants {
    protected static BitmapLruCache sCachedTiles = null;
    private Context context;
    static final String TAG = "MapTileCache";
    private static final String DISK_CACHE_SUBDIR = "mapbox_tiles_cache";
    private int mMaximumCacheSize;
    private boolean mDiskCacheEnabled = false;

    public MapTileCache(Context aContext) {
        this(aContext, 0x6400000);
    }

    public MapTileCache(Context aContext, int aMaximumCacheSize) {
        this.context = aContext;
        this.mMaximumCacheSize = aMaximumCacheSize;
    }

    protected BitmapLruCache getCache() {
        if (sCachedTiles == null) {
            File cacheDir = MapTileCache.getDiskCacheDir(this.context, DISK_CACHE_SUBDIR);
            if (!cacheDir.exists()) {
                if (cacheDir.mkdirs()) {
                    Log.i((String)TAG, (String)("created cacheDir " + cacheDir.getAbsolutePath()));
                } else {
                    Log.e((String)TAG, (String)("can't create cacheDir " + cacheDir));
                }
            } else {
                Log.i((String)TAG, (String)("cacheDir previously created '" + cacheDir.getAbsolutePath() + "'"));
            }
            sCachedTiles = new BitmapLruCache.Builder(this.context).setMemoryCacheEnabled(true).setMemoryCacheMaxSize(BitmapUtils.calculateMemoryCacheSize(this.context)).setDiskCacheEnabled(this.mDiskCacheEnabled).setDiskCacheMaxSize(this.mMaximumCacheSize).setDiskCacheLocation(cacheDir).build();
            Log.i((String)TAG, (String)("Disk Cache Enabled: '" + sCachedTiles.isDiskCacheEnabled() + "'; Memory Cache Enabled: '" + sCachedTiles.isMemoryCacheEnabled() + "'"));
        }
        return sCachedTiles;
    }

    public String getCacheKey(MapTile aTile) {
        return aTile.getCacheKey();
    }

    public CacheableBitmapDrawable getMapTile(MapTile aTile) {
        String key = this.getCacheKey(aTile);
        CacheableBitmapDrawable result = this.getCache().getFromMemoryCache(key);
        if (result == null) {
            result = this.getCache().getFromDiskCache(key, null);
        }
        return result;
    }

    public CacheableBitmapDrawable getMapTileFromMemory(MapTile aTile) {
        return this.getCache().getFromMemoryCache(this.getCacheKey(aTile));
    }

    public CacheableBitmapDrawable getMapTileFromDisk(MapTile aTile) {
        return this.getCache().getFromDiskCache(this.getCacheKey(aTile), null);
    }

    public CacheableBitmapDrawable putTileStream(MapTile aTile, InputStream inputStream, BitmapFactory.Options decodeOpts) {
        return this.getCache().put(this.getCacheKey(aTile), inputStream, decodeOpts);
    }

    public CacheableBitmapDrawable putTileBitmap(MapTile aTile, Bitmap bitmap) {
        return this.getCache().put(this.getCacheKey(aTile), bitmap);
    }

    public CacheableBitmapDrawable putTile(MapTile aTile, Drawable aDrawable) {
        if (aDrawable != null && aDrawable instanceof BitmapDrawable) {
            String key = this.getCacheKey(aTile);
            CacheableBitmapDrawable drawable2 = null;
            if (!this.getCache().containsInMemoryCache(key)) {
                drawable2 = this.getCache().putInMemoryCache(this.getCacheKey(aTile), ((BitmapDrawable)aDrawable).getBitmap());
            }
            if (this.getCache().isDiskCacheEnabled() && !this.getCache().containsInDiskCache(key)) {
                if (drawable2 != null) {
                    this.getCache().putInDiskCache(this.getCacheKey(aTile), drawable2);
                } else {
                    this.getCache().putInDiskCache(this.getCacheKey(aTile), ((BitmapDrawable)aDrawable).getBitmap());
                }
            }
            return drawable2;
        }
        return null;
    }

    public CacheableBitmapDrawable putTileInMemoryCache(MapTile aTile, Bitmap aBitmap) {
        if (aBitmap != null) {
            return this.getCache().putInMemoryCache(this.getCacheKey(aTile), aBitmap);
        }
        return null;
    }

    public CacheableBitmapDrawable putTileInMemoryCache(MapTile aTile, Drawable aDrawable) {
        if (aDrawable != null && aDrawable instanceof BitmapDrawable) {
            String key = this.getCacheKey(aTile);
            if (aDrawable instanceof CacheableBitmapDrawable) {
                return this.getCache().putInMemoryCache(key, (CacheableBitmapDrawable)aDrawable);
            }
            return this.getCache().putInMemoryCache(key, ((BitmapDrawable)aDrawable).getBitmap());
        }
        return null;
    }

    public CacheableBitmapDrawable putTileInDiskCache(MapTile aTile, Drawable aDrawable) {
        if (aDrawable != null && aDrawable instanceof BitmapDrawable) {
            String key = this.getCacheKey(aTile);
            if (this.getCache().isDiskCacheEnabled() && !this.getCache().containsInDiskCache(key)) {
                return this.getCache().putInDiskCache(this.getCacheKey(aTile), ((BitmapDrawable)aDrawable).getBitmap());
            }
        }
        return null;
    }

    public boolean containsTile(MapTile aTile) {
        return this.getCache().contains(this.getCacheKey(aTile));
    }

    public boolean containsTileInDiskCache(MapTile aTile) {
        return this.getCache().isDiskCacheEnabled() && this.getCache().containsInDiskCache(this.getCacheKey(aTile));
    }

    public void removeTile(MapTile aTile) {
        this.getCache().remove(this.getCacheKey(aTile));
    }

    public void removeTileFromMemory(MapTile aTile) {
        String key = this.getCacheKey(aTile);
        this.getCache().removeFromMemoryCache(key);
    }

    public void purgeMemoryCache() {
        this.getCache().purgeMemoryCache();
    }

    public void purgeDiskCache() {
        this.getCache().purgeDiskCache();
    }

    public CacheableBitmapDrawable createCacheableBitmapDrawable(Bitmap bitmap, MapTile aTile) {
        return this.getCache().createCacheableBitmapDrawable(bitmap, this.getCacheKey(aTile), -1);
    }

    public Bitmap getBitmapFromRemoved(int width, int height) {
        return this.getCache().getBitmapFromRemoved(width, height);
    }

    public Bitmap decodeBitmap(byte[] data, BitmapFactory.Options opts) {
        return this.getCache().decodeBitmap(new BitmapLruCache.ByteArrayInputStreamProvider(data), opts);
    }

    public Bitmap decodeBitmap(BitmapLruCache.InputStreamProvider ip, BitmapFactory.Options opts) {
        return this.getCache().decodeBitmap(ip, opts);
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = context.getExternalCacheDir() != null && ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        Log.i((String)TAG, (String)("cachePath: '" + cachePath + "'"));
        return new File(cachePath, uniqueName);
    }

    public void setDiskCacheEnabled(boolean enabled) {
        if (this.mDiskCacheEnabled != enabled) {
            this.mDiskCacheEnabled = enabled;
            sCachedTiles = null;
        }
    }

    public boolean isDiskCacheEnabled() {
        return this.mDiskCacheEnabled;
    }
}

