/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.events;

import android.os.Handler;
import android.util.Log;
import com.mapbox.mapboxsdk.events.MapEvent;
import com.mapbox.mapboxsdk.events.MapListener;
import com.mapbox.mapboxsdk.events.RotateEvent;
import com.mapbox.mapboxsdk.events.ScrollEvent;
import com.mapbox.mapboxsdk.events.ZoomEvent;

public class DelayedMapListener
implements MapListener {
    protected static final int DEFAULT_DELAY = 100;
    MapListener wrappedListener;
    protected long delay;
    protected Handler handler;
    protected CallbackTask callback;
    private static final String TAG = "DelayedMapListener";

    public DelayedMapListener(MapListener aWrappedListener, long aDelay) {
        this.wrappedListener = aWrappedListener;
        this.delay = aDelay;
        this.handler = new Handler();
        this.callback = null;
    }

    public DelayedMapListener(MapListener aWrappedListener) {
        this(aWrappedListener, 100L);
    }

    @Override
    public void onScroll(ScrollEvent event) {
        this.dispatch(event);
    }

    @Override
    public void onZoom(ZoomEvent event) {
        this.dispatch(event);
    }

    @Override
    public void onRotate(RotateEvent event) {
        this.dispatch(event);
    }

    protected void dispatch(MapEvent event) {
        if (this.callback != null) {
            this.handler.removeCallbacks((Runnable)this.callback);
        }
        this.callback = new CallbackTask(event);
        this.handler.postDelayed((Runnable)this.callback, this.delay);
    }

    private class CallbackTask
    implements Runnable {
        private final MapEvent event;

        public CallbackTask(MapEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (this.event instanceof ScrollEvent) {
                DelayedMapListener.this.wrappedListener.onScroll((ScrollEvent)this.event);
            } else if (this.event instanceof ZoomEvent) {
                DelayedMapListener.this.wrappedListener.onZoom((ZoomEvent)this.event);
            } else if (this.event instanceof RotateEvent) {
                DelayedMapListener.this.wrappedListener.onRotate((RotateEvent)this.event);
            } else {
                Log.i((String)DelayedMapListener.TAG, (String)("Unknown event received: " + this.event));
            }
        }
    }
}

