/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import android.os.Parcel;
import android.os.Parcelable;
import com.cocoahero.android.geojson.GeoJSONObject;
import com.cocoahero.android.geojson.Geometry;
import com.cocoahero.android.geojson.Position;
import com.cocoahero.android.geojson.PositionList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiPoint
extends Geometry {
    private final PositionList mPositionList = new PositionList();
    public static final Parcelable.Creator<MultiPoint> CREATOR = new Parcelable.Creator<MultiPoint>(){

        public MultiPoint createFromParcel(Parcel in) {
            return (MultiPoint)GeoJSONObject.readParcel(in);
        }

        public MultiPoint[] newArray(int size) {
            return new MultiPoint[size];
        }
    };

    public MultiPoint() {
    }

    public MultiPoint(JSONObject json) {
        super(json);
        this.setPositions(json.optJSONArray("coordinates"));
    }

    public MultiPoint(JSONArray positions) {
        this.setPositions(positions);
    }

    public void addPosition(Position position) {
        this.mPositionList.addPosition(position);
    }

    public void removePosition(Position position) {
        this.mPositionList.removePosition(position);
    }

    public List<Position> getPositions() {
        return this.mPositionList.getPositions();
    }

    public void setPositions(JSONArray positions) {
        this.mPositionList.setPositions(positions);
    }

    public void setPositions(List<Position> positions) {
        this.mPositionList.setPositions(positions);
    }

    @Override
    public String getType() {
        return "MultiPoint";
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = super.toJSON();
        json.put("coordinates", (Object)this.mPositionList.toJSON());
        return json;
    }
}

