/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.bitmapcache;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.jakewharton.disklrucache.DiskLruCache;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import uk.co.senab.bitmapcache.BitmapMemoryLruCache;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;
import uk.co.senab.bitmapcache.Constants;
import uk.co.senab.bitmapcache.IoUtils;
import uk.co.senab.bitmapcache.Md5;
import uk.co.senab.bitmapcache.SDK11;

public class BitmapLruCache {
    static final int DISK_CACHE_FLUSH_DELAY_SECS = 5;
    private File mTempDir;
    private Resources mResources;
    private BitmapMemoryLruCache mMemoryCache;
    private RecyclePolicy mRecyclePolicy;
    private DiskLruCache mDiskCache;
    private HashMap<String, ReentrantLock> mDiskCacheEditLocks;
    private ScheduledThreadPoolExecutor mDiskCacheFlusherExecutor;
    private DiskCacheFlushRunnable mDiskCacheFlusherRunnable;
    private ScheduledFuture<?> mDiskCacheFuture;

    private static void checkNotOnMainThread() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("This method should not be called from the main/UI thread.");
        }
    }

    private static String transformUrlForDiskCacheKey(String url) {
        return Md5.encode(url);
    }

    BitmapLruCache(Context context) {
        if (null != context) {
            context = context.getApplicationContext();
            this.mTempDir = context.getCacheDir();
            this.mResources = context.getResources();
        }
    }

    public boolean contains(String url) {
        return this.containsInMemoryCache(url) || this.containsInDiskCache(url);
    }

    public boolean containsInDiskCache(String url) {
        if (null != this.mDiskCache) {
            BitmapLruCache.checkNotOnMainThread();
            try {
                return null != this.mDiskCache.get(BitmapLruCache.transformUrlForDiskCacheKey(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean containsInMemoryCache(String url) {
        return null != this.mMemoryCache && null != this.mMemoryCache.get(url);
    }

    public CacheableBitmapDrawable get(String url) {
        return this.get(url, null);
    }

    public CacheableBitmapDrawable get(String url, BitmapFactory.Options decodeOpts) {
        CacheableBitmapDrawable result = this.getFromMemoryCache(url);
        if (null == result) {
            result = this.getFromDiskCache(url, decodeOpts);
        }
        return result;
    }

    public CacheableBitmapDrawable getFromDiskCache(String url, BitmapFactory.Options decodeOpts) {
        CacheableBitmapDrawable result = null;
        if (null != this.mDiskCache) {
            BitmapLruCache.checkNotOnMainThread();
            try {
                String key = BitmapLruCache.transformUrlForDiskCacheKey(url);
                result = this.decodeBitmapToDrawable(new SnapshotInputStreamProvider(key), url, decodeOpts);
                if (null != result) {
                    if (null != this.mMemoryCache) {
                        this.mMemoryCache.put(result);
                    }
                } else {
                    this.mDiskCache.remove(key);
                    this.scheduleDiskCacheFlush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableBitmapDrawable getFromMemoryCache(String url) {
        CacheableBitmapDrawable result = null;
        if (null != this.mMemoryCache) {
            BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
            synchronized (bitmapMemoryLruCache) {
                result = (CacheableBitmapDrawable)((Object)this.mMemoryCache.get(url));
                if (null != result && !result.isBitmapValid()) {
                    this.mMemoryCache.remove(url);
                    result = null;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapFromRemoved(int width, int height) {
        if (null != this.mMemoryCache) {
            BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
            synchronized (bitmapMemoryLruCache) {
                return this.mMemoryCache.getBitmapFromRemoved(width, height);
            }
        }
        return null;
    }

    public boolean isDiskCacheEnabled() {
        return null != this.mDiskCache;
    }

    public boolean isMemoryCacheEnabled() {
        return null != this.mMemoryCache;
    }

    public CacheableBitmapDrawable put(String url, Bitmap bitmap) {
        return this.put(url, bitmap, Bitmap.CompressFormat.PNG, 100);
    }

    public CacheableBitmapDrawable put(String url, Bitmap bitmap, Bitmap.CompressFormat compressFormat, int compressQuality) {
        CacheableBitmapDrawable d = new CacheableBitmapDrawable(url, this.mResources, bitmap, this.mRecyclePolicy, -1);
        this.putInMemoryCache(url, d, compressFormat, compressQuality);
        this.putInDiskCache(url, d, compressFormat, compressQuality);
        return d;
    }

    public CacheableBitmapDrawable putInMemoryCache(String url, Bitmap bitmap) {
        return this.putInMemoryCache(url, bitmap, Bitmap.CompressFormat.PNG, 100);
    }

    public CacheableBitmapDrawable putInMemoryCache(String url, CacheableBitmapDrawable drawable2) {
        return this.putInMemoryCache(url, drawable2, Bitmap.CompressFormat.PNG, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableBitmapDrawable putInMemoryCache(String url, CacheableBitmapDrawable drawable2, Bitmap.CompressFormat compressFormat, int compressQuality) {
        if (null != this.mMemoryCache) {
            BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
            synchronized (bitmapMemoryLruCache) {
                this.mMemoryCache.put(drawable2);
            }
        }
        return drawable2;
    }

    public CacheableBitmapDrawable putInMemoryCache(String url, Bitmap bitmap, Bitmap.CompressFormat compressFormat, int compressQuality) {
        CacheableBitmapDrawable d = new CacheableBitmapDrawable(url, this.mResources, bitmap, this.mRecyclePolicy, -1);
        return this.putInMemoryCache(url, d, compressFormat, compressQuality);
    }

    public CacheableBitmapDrawable putInDiskCache(String url, Bitmap bitmap) {
        return this.putInDiskCache(url, bitmap, Bitmap.CompressFormat.PNG, 100);
    }

    public CacheableBitmapDrawable putInDiskCache(String url, CacheableBitmapDrawable drawable2) {
        return this.putInDiskCache(url, drawable2, Bitmap.CompressFormat.PNG, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableBitmapDrawable putInDiskCache(String url, CacheableBitmapDrawable drawable2, Bitmap.CompressFormat compressFormat, int compressQuality) {
        if (null != this.mDiskCache) {
            BitmapLruCache.checkNotOnMainThread();
            String key = BitmapLruCache.transformUrlForDiskCacheKey(url);
            ReentrantLock lock = this.getLockForDiskCacheEdit(key);
            lock.lock();
            OutputStream os = null;
            try {
                DiskLruCache.Editor editor = this.mDiskCache.edit(key);
                os = editor.newOutputStream(0);
                drawable2.getBitmap().compress(compressFormat, compressQuality, os);
                os.flush();
                editor.commit();
            }
            catch (IOException e) {
                try {
                    Log.e((String)Constants.LOG_TAG, (String)"Error while writing to disk cache", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeStream(os);
                    lock.unlock();
                    this.scheduleDiskCacheFlush();
                    throw throwable;
                }
                IoUtils.closeStream(os);
                lock.unlock();
                this.scheduleDiskCacheFlush();
            }
            IoUtils.closeStream(os);
            lock.unlock();
            this.scheduleDiskCacheFlush();
        }
        return drawable2;
    }

    public CacheableBitmapDrawable putInDiskCache(String url, Bitmap bitmap, Bitmap.CompressFormat compressFormat, int compressQuality) {
        CacheableBitmapDrawable d = new CacheableBitmapDrawable(url, this.mResources, bitmap, this.mRecyclePolicy, -1);
        return this.putInDiskCache(url, d, compressFormat, compressQuality);
    }

    public CacheableBitmapDrawable put(String url, InputStream inputStream) {
        return this.put(url, inputStream, null);
    }

    public CacheableBitmapDrawable put(String url, byte[] data, BitmapFactory.Options decodeOpts) {
        CacheableBitmapDrawable d;
        BitmapLruCache.checkNotOnMainThread();
        if (null == this.mDiskCache && null != (d = this.decodeBitmapToDrawable(new ByteArrayInputStreamProvider(data), url, decodeOpts))) {
            if (null != this.mMemoryCache) {
                d.setCached(true);
                this.mMemoryCache.put(d.getUrl(), (Object)d);
            }
            return d;
        }
        return this.put(url, new ByteArrayInputStream(data), decodeOpts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableBitmapDrawable put(String url, InputStream inputStream, BitmapFactory.Options decodeOpts) {
        if (inputStream == null) {
            return null;
        }
        BitmapLruCache.checkNotOnMainThread();
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("bitmapcache_", null, this.mTempDir);
            IoUtils.copy(inputStream, tmpFile);
        }
        catch (IOException e) {
            Log.e((String)Constants.LOG_TAG, (String)("Error writing to saving stream to temp file: " + url), (Throwable)e);
        }
        CacheableBitmapDrawable d = null;
        if (null != tmpFile) {
            d = this.decodeBitmapToDrawable(new FileInputStreamProvider(tmpFile), url, decodeOpts);
            if (d != null) {
                if (null != this.mMemoryCache) {
                    d.setCached(true);
                    BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
                    synchronized (bitmapMemoryLruCache) {
                        this.mMemoryCache.put(d.getUrl(), (Object)d);
                    }
                }
                if (null != this.mDiskCache) {
                    String key = BitmapLruCache.transformUrlForDiskCacheKey(url);
                    ReentrantLock lock = this.getLockForDiskCacheEdit(url);
                    lock.lock();
                    try {
                        DiskLruCache.Editor editor = this.mDiskCache.edit(key);
                        IoUtils.copy(tmpFile, editor.newOutputStream(0));
                        editor.commit();
                    }
                    catch (IOException e) {
                        Log.e((String)Constants.LOG_TAG, (String)("Error writing to disk cache. URL: " + url), (Throwable)e);
                    }
                    finally {
                        lock.unlock();
                        this.scheduleDiskCacheFlush();
                    }
                }
            }
            tmpFile.delete();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String url) {
        if (null != this.mMemoryCache) {
            BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
            synchronized (bitmapMemoryLruCache) {
                this.mMemoryCache.remove(url);
            }
        }
        if (null != this.mDiskCache) {
            BitmapLruCache.checkNotOnMainThread();
            try {
                this.mDiskCache.remove(BitmapLruCache.transformUrlForDiskCacheKey(url));
                this.scheduleDiskCacheFlush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMemoryCache(String url) {
        if (null != this.mMemoryCache) {
            BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
            synchronized (bitmapMemoryLruCache) {
                this.mMemoryCache.remove(url);
            }
        }
    }

    public void removeFromDiskCache(String url) {
        if (null != this.mDiskCache) {
            BitmapLruCache.checkNotOnMainThread();
            try {
                this.mDiskCache.remove(BitmapLruCache.transformUrlForDiskCacheKey(url));
                this.scheduleDiskCacheFlush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void resizeMemoryForTiles(int numberOfTiles) {
        this.mMemoryCache.resizeMemoryForTiles(numberOfTiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimMemory() {
        if (null != this.mMemoryCache) {
            BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
            synchronized (bitmapMemoryLruCache) {
                this.mMemoryCache.trimMemory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeMemoryCache() {
        if (null != this.mMemoryCache) {
            BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
            synchronized (bitmapMemoryLruCache) {
                this.mMemoryCache.evictAll();
            }
        }
    }

    public void purgeDiskCache() {
        if (null != this.mDiskCache) {
            BitmapLruCache.checkNotOnMainThread();
            try {
                this.mDiskCache.delete();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    synchronized void setDiskCache(DiskLruCache diskCache) {
        this.mDiskCache = diskCache;
        if (null != diskCache) {
            this.mDiskCacheEditLocks = new HashMap();
            this.mDiskCacheFlusherExecutor = new ScheduledThreadPoolExecutor(1);
            this.mDiskCacheFlusherRunnable = new DiskCacheFlushRunnable(diskCache);
        }
    }

    void setMemoryCache(BitmapMemoryLruCache memoryCache) {
        this.mMemoryCache = memoryCache;
        this.mRecyclePolicy = memoryCache.getRecyclePolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock getLockForDiskCacheEdit(String url) {
        HashMap<String, ReentrantLock> hashMap = this.mDiskCacheEditLocks;
        synchronized (hashMap) {
            ReentrantLock lock = this.mDiskCacheEditLocks.get(url);
            if (null == lock) {
                lock = new ReentrantLock();
                this.mDiskCacheEditLocks.put(url, lock);
            }
            return lock;
        }
    }

    private void scheduleDiskCacheFlush() {
        if (null != this.mDiskCacheFuture) {
            this.mDiskCacheFuture.cancel(false);
        }
        this.mDiskCacheFuture = this.mDiskCacheFlusherExecutor.schedule(this.mDiskCacheFlusherRunnable, 5L, TimeUnit.SECONDS);
    }

    public CacheableBitmapDrawable createCacheableBitmapDrawable(Bitmap bitmap, String url, int source) {
        if (bitmap != null) {
            return new CacheableBitmapDrawable(url, this.mResources, bitmap, this.mRecyclePolicy, source);
        }
        return null;
    }

    private CacheableBitmapDrawable decodeBitmapToDrawable(InputStreamProvider ip, String url, BitmapFactory.Options opts) {
        AtomicInteger source = new AtomicInteger(0);
        Bitmap result = this.decodeBitmap(ip, opts, source);
        return this.createCacheableBitmapDrawable(result, url, source.get());
    }

    public Bitmap decodeBitmap(InputStreamProvider ip, BitmapFactory.Options opts) {
        return this.decodeBitmap(ip, opts, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap decodeBitmap(InputStreamProvider ip, BitmapFactory.Options opts, AtomicInteger source) {
        InputStream is;
        Bitmap bm;
        block10: {
            bm = null;
            is = null;
            if (source != null) {
                source.set(0);
            }
            try {
                if (this.mRecyclePolicy.canInBitmap()) {
                    if (opts == null) {
                        opts = new BitmapFactory.Options();
                    }
                    if (opts.inSampleSize <= 1) {
                        opts.inSampleSize = 1;
                        if (this.addInBitmapOptions(ip, opts) && source != null) {
                            source.set(1);
                        }
                    }
                }
                if ((is = ip.getInputStream()) == null && ip instanceof ByteArrayInputStreamProvider) {
                    byte[] data = ((ByteArrayInputStreamProvider)ip).array;
                    bm = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
                    break block10;
                }
                bm = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
            }
            catch (Exception e) {
                try {
                    Log.e((String)Constants.LOG_TAG, (String)"Unable to decode stream", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeStream(is);
                    throw throwable;
                }
                IoUtils.closeStream(is);
            }
        }
        IoUtils.closeStream(is);
        return bm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addInBitmapOptions(InputStreamProvider ip, BitmapFactory.Options opts) {
        InputStream is = ip.getInputStream();
        opts.inJustDecodeBounds = true;
        if (is == null && ip instanceof ByteArrayInputStreamProvider) {
            byte[] data = ((ByteArrayInputStreamProvider)ip).array;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
        } else {
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
        }
        IoUtils.closeStream(is);
        opts.inJustDecodeBounds = false;
        opts.inMutable = true;
        BitmapMemoryLruCache bitmapMemoryLruCache = this.mMemoryCache;
        synchronized (bitmapMemoryLruCache) {
            Bitmap reusableBm = this.mMemoryCache.getBitmapFromRemoved(opts.outWidth, opts.outHeight);
            if (reusableBm != null) {
                if (Constants.DEBUG) {
                    Log.i((String)Constants.LOG_TAG, (String)"Using inBitmap");
                }
                SDK11.addInBitmapOption(opts, reusableBm);
                return true;
            }
        }
        return false;
    }

    final class SnapshotInputStreamProvider
    implements InputStreamProvider {
        final String mKey;

        SnapshotInputStreamProvider(String key) {
            this.mKey = key;
        }

        @Override
        public InputStream getInputStream() {
            try {
                DiskLruCache.Snapshot snapshot = BitmapLruCache.this.mDiskCache.get(this.mKey);
                if (snapshot != null) {
                    return snapshot.getInputStream(0);
                }
            }
            catch (IOException e) {
                Log.e((String)Constants.LOG_TAG, (String)("Could open disk cache for url: " + this.mKey), (Throwable)e);
            }
            return null;
        }
    }

    public static class ByteArrayInputStreamProvider
    implements InputStreamProvider {
        final byte[] array;

        public ByteArrayInputStreamProvider(byte[] array) {
            this.array = array;
        }

        @Override
        public InputStream getInputStream() {
            return null;
        }
    }

    public static class FileInputStreamProvider
    implements InputStreamProvider {
        final File mFile;

        public FileInputStreamProvider(File file) {
            this.mFile = file;
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new FileInputStream(this.mFile);
            }
            catch (FileNotFoundException e) {
                Log.e((String)Constants.LOG_TAG, (String)("Could not decode file: " + this.mFile.getAbsolutePath()), (Throwable)e);
                return null;
            }
        }
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream();
    }

    static final class DiskCacheFlushRunnable
    implements Runnable {
        private final DiskLruCache mDiskCache;

        public DiskCacheFlushRunnable(DiskLruCache cache) {
            this.mDiskCache = cache;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            if (Constants.DEBUG) {
                Log.d((String)Constants.LOG_TAG, (String)"Flushing Disk Cache");
            }
            try {
                this.mDiskCache.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final class Builder {
        static final int MEGABYTE = 0x100000;
        static final float DEFAULT_MEMORY_CACHE_HEAP_RATIO = 0.125f;
        static final float MAX_MEMORY_CACHE_HEAP_RATIO = 0.75f;
        static final int DEFAULT_DISK_CACHE_MAX_SIZE_MB = 10;
        static final int DEFAULT_MEM_CACHE_MAX_SIZE_MB = 3;
        static final RecyclePolicy DEFAULT_RECYCLE_POLICY = RecyclePolicy.PRE_HONEYCOMB_ONLY;
        static final float DEFAULT_MEMORY_CACHE_HEAP_PERCENTAGE = 12.5f;
        static final float MAX_MEMORY_CACHE_HEAP_PERCENTAGE = 75.0f;
        private Context mContext;
        private boolean mDiskCacheEnabled;
        private File mDiskCacheLocation;
        private long mDiskCacheMaxSize;
        private boolean mMemoryCacheEnabled;
        private int mMemoryCacheMaxSize;
        private RecyclePolicy mRecyclePolicy;

        private static long getHeapSize() {
            return Runtime.getRuntime().maxMemory();
        }

        public Builder() {
            this(null);
        }

        public Builder(Context context) {
            this.mContext = context;
            this.mDiskCacheMaxSize = 0xA00000L;
            this.mMemoryCacheEnabled = true;
            this.mMemoryCacheMaxSize = 0x300000;
            this.mRecyclePolicy = DEFAULT_RECYCLE_POLICY;
        }

        public BitmapLruCache build() {
            final BitmapLruCache cache = new BitmapLruCache(this.mContext);
            if (this.isValidOptionsForMemoryCache()) {
                if (Constants.DEBUG) {
                    Log.d((String)"BitmapLruCache.Builder", (String)"Creating Memory Cache");
                }
                cache.setMemoryCache(new BitmapMemoryLruCache(this.mMemoryCacheMaxSize, this.mRecyclePolicy));
            }
            if (this.isValidOptionsForDiskCache()) {
                new AsyncTask<Void, Void, DiskLruCache>(){

                    protected DiskLruCache doInBackground(Void ... params) {
                        try {
                            return DiskLruCache.open((File)Builder.this.mDiskCacheLocation, (int)0, (int)1, (long)Builder.this.mDiskCacheMaxSize);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }

                    protected void onPostExecute(DiskLruCache result) {
                        cache.setDiskCache(result);
                    }
                }.execute((Object[])new Void[0]);
            }
            return cache;
        }

        public Builder setDiskCacheEnabled(boolean enabled) {
            this.mDiskCacheEnabled = enabled;
            return this;
        }

        public Builder setDiskCacheLocation(File location) {
            this.mDiskCacheLocation = location;
            return this;
        }

        public Builder setDiskCacheMaxSize(long maxSize) {
            this.mDiskCacheMaxSize = maxSize;
            return this;
        }

        public Builder setMemoryCacheEnabled(boolean enabled) {
            this.mMemoryCacheEnabled = enabled;
            return this;
        }

        public Builder setMemoryCacheMaxSize(int size) {
            this.mMemoryCacheMaxSize = size;
            return this;
        }

        public Builder setMemoryCacheMaxSizeUsingHeapSize() {
            return this.setMemoryCacheMaxSizeUsingHeapSize(0.125f);
        }

        public Builder setMemoryCacheMaxSizeUsingHeapSize(float percentageOfHeap) {
            int size = Math.round((float)Builder.getHeapSize() * Math.min(percentageOfHeap, 0.75f));
            return this.setMemoryCacheMaxSize(size);
        }

        public Builder setRecyclePolicy(RecyclePolicy recyclePolicy) {
            if (null == recyclePolicy) {
                throw new IllegalArgumentException("The recycle policy can not be null");
            }
            this.mRecyclePolicy = recyclePolicy;
            return this;
        }

        private boolean isValidOptionsForDiskCache() {
            boolean valid = this.mDiskCacheEnabled;
            if (valid) {
                if (null == this.mDiskCacheLocation) {
                    Log.i((String)Constants.LOG_TAG, (String)"Disk Cache has been enabled, but no location given. Please call setDiskCacheLocation(...)");
                    valid = false;
                } else if (!this.mDiskCacheLocation.canWrite()) {
                    Log.i((String)Constants.LOG_TAG, (String)"Disk Cache Location is not write-able, disabling disk caching.");
                    valid = false;
                }
            }
            return valid;
        }

        private boolean isValidOptionsForMemoryCache() {
            return this.mMemoryCacheEnabled && this.mMemoryCacheMaxSize > 0;
        }
    }

    public static enum RecyclePolicy {
        DISABLED,
        PRE_HONEYCOMB_ONLY,
        ALWAYS;


        boolean canInBitmap() {
            switch (this) {
                case PRE_HONEYCOMB_ONLY: 
                case DISABLED: {
                    return Build.VERSION.SDK_INT >= 11;
                }
            }
            return false;
        }

        boolean canRecycle() {
            switch (this) {
                case DISABLED: {
                    return false;
                }
                case PRE_HONEYCOMB_ONLY: {
                    return Build.VERSION.SDK_INT < 11;
                }
                case ALWAYS: {
                    return true;
                }
            }
            return false;
        }
    }
}

