/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.renderer;

import android.graphics.Paint;
import android.graphics.Path;
import com.mapbox.mapboxsdk.views.MapView;
import com.spatialdev.osm.model.OSMWay;
import com.spatialdev.osm.renderer.OSMPath;

public class OSMLine
extends OSMPath {
    private static final float DEFAULT_WIDTH = 13.0f;
    private static final int DEFAULT_A = 125;
    private static final int DEFAULT_R = 126;
    private static final int DEFAULT_G = 188;
    private static final int DEFAULT_B = 111;
    private static final float DEFAULT_SELECTED_WIDTH = 15.0f;
    private static final int DEFAULT_SELECTED_A = 180;
    private static final int DEFAULT_SELECTED_R = 255;
    private static final int DEFAULT_SELECTED_G = 140;
    private static final int DEFAULT_SELECTED_B = 0;
    private float width;
    private int a;
    private int r;
    private int g;
    private int b;

    protected OSMLine(OSMWay w, MapView mv) {
        this(w, mv, 125, 126, 188, 111, 13.0f);
    }

    protected OSMLine(OSMWay w, MapView mv, int a, int r, int g, int b, float width) {
        super(w, mv);
        this.width = width;
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setARGB(a, r, g, b);
        this.setStrokeWidth(width);
    }

    @Override
    public void select() {
        this.paint.setARGB(180, 255, 140, 0);
        this.setStrokeWidth(15.0f);
    }

    @Override
    public void deselect() {
        this.paint.setARGB(this.a, this.r, this.g, this.b);
        this.setStrokeWidth(this.width);
    }

    @Override
    void clipOrDrawPath(Path path, double[] projectedPoint, double[] nextProjectedPoint, double[] screenPoint) {
        int projX = (int)projectedPoint[0];
        int projY = (int)projectedPoint[1];
        if (this.viewPortBounds.contains(projX, projY)) {
            if (this.pathLineToReady) {
                path.lineTo((float)screenPoint[0], (float)screenPoint[1]);
            } else {
                path.moveTo((float)screenPoint[0], (float)screenPoint[1]);
                this.pathLineToReady = true;
            }
        } else {
            int projYNext;
            int projXNext;
            if (this.pathLineToReady) {
                path.lineTo((float)screenPoint[0], (float)screenPoint[1]);
                this.pathLineToReady = false;
                return;
            }
            if (nextProjectedPoint != null && this.viewPortBounds.contains(projXNext = (int)nextProjectedPoint[0], projYNext = (int)nextProjectedPoint[1])) {
                path.moveTo((float)screenPoint[0], (float)screenPoint[1]);
                this.pathLineToReady = true;
            }
        }
    }
}

