/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.model;

import com.mapbox.mapboxsdk.geometry.LatLng;
import com.spatialdev.osm.model.OSMElement;
import com.spatialdev.osm.model.OSMRelation;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class OSMNode
extends OSMElement {
    private double lat;
    private double lng;
    private LinkedList<OSMRelation> linkedRelations = new LinkedList();

    public OSMNode(String idStr, String latStr, String lonStr, String versionStr, String timestampStr, String changesetStr, String uidStr, String userStr) {
        super(idStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
        this.lat = Double.valueOf(latStr);
        this.lng = Double.valueOf(lonStr);
    }

    public LatLng getLatLng() {
        return new LatLng(this.lat, this.lng);
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public void addRelation(OSMRelation relation) {
        this.linkedRelations.push(relation);
    }

    public List<OSMRelation> getRelations() {
        return this.linkedRelations;
    }

    @Override
    void xml(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(null, "node");
        if (this.isModified()) {
            xmlSerializer.attribute(null, "action", "modify");
        }
        this.setOsmElementXmlAttributes(xmlSerializer);
        xmlSerializer.attribute(null, "lat", String.valueOf(this.lat));
        xmlSerializer.attribute(null, "lon", String.valueOf(this.lng));
        super.xml(xmlSerializer);
        xmlSerializer.endTag(null, "node");
    }
}

