/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.model;

import android.content.Context;
import android.text.TextUtils;
import android.util.Xml;
import com.spatialdev.osm.model.OSMDataSet;
import com.spatialdev.osm.model.OSMElement;
import com.spatialdev.osm.model.OSMNode;
import com.spatialdev.osm.model.OSMRelation;
import com.spatialdev.osm.model.OSMWay;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OSMXmlParser {
    private static final String ns = null;
    private XmlPullParser parser;
    private OSMDataSet ds = new OSMDataSet();
    protected long elementReadCount = 0L;
    protected long nodeReadCount = 0L;
    protected long wayReadCount = 0L;
    protected long relationReadCount = 0L;
    protected long tagReadCount = 0L;

    public static OSMDataSet parseFromAssets(Context context, String fileName) throws IOException {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            throw new NullPointerException("No OSM XML File Name passed in.");
        }
        InputStream in = context.getAssets().open(fileName);
        return OSMXmlParser.parseFromInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OSMDataSet parseFromInputStream(InputStream in) throws IOException {
        OSMXmlParser osmXmlParser = new OSMXmlParser();
        try {
            osmXmlParser.parse(in);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return osmXmlParser.getDataSet();
    }

    protected OSMXmlParser() {
    }

    public OSMDataSet getDataSet() {
        return this.ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream in) throws XmlPullParserException, IOException {
        try {
            this.parser = Xml.newPullParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            this.parser.setInput(in, null);
            this.parser.nextTag();
            this.readOsm();
            this.ds.postProcessing();
        }
        finally {
            in.close();
        }
    }

    private void readOsm() throws IOException, XmlPullParserException {
        this.parser.require(2, ns, "osm");
        while (this.parser.next() != 3) {
            if (this.parser.getEventType() != 2) continue;
            String name = this.parser.getName();
            if (name.equals("note")) {
                this.readNote();
            } else if (name.equals("meta")) {
                this.readMeta();
            } else if (name.equals("node")) {
                this.readNode();
            } else if (name.equals("way")) {
                this.readWay();
            } else if (name.equals("relation")) {
                this.readRelation();
            } else {
                this.skip();
            }
            ++this.elementReadCount;
            if (this.elementReadCount % 500L != 0L) continue;
            this.notifyProgress();
        }
    }

    protected void notifyProgress() {
    }

    private void readNote() throws XmlPullParserException, IOException {
        String note = this.readText();
        this.ds.createNote(note);
    }

    private void readMeta() throws XmlPullParserException, IOException {
        this.parser.next();
        String osmBase = this.parser.getAttributeValue(ns, "osm_base");
        this.ds.createMeta(osmBase);
        this.parser.next();
    }

    private void readNode() throws XmlPullParserException, IOException {
        String idStr = this.parser.getAttributeValue(ns, "id");
        String latStr = this.parser.getAttributeValue(ns, "lat");
        String lonStr = this.parser.getAttributeValue(ns, "lon");
        String versionStr = this.parser.getAttributeValue(ns, "version");
        String timestampStr = this.parser.getAttributeValue(ns, "timestamp");
        String changesetStr = this.parser.getAttributeValue(ns, "changeset");
        String uidStr = this.parser.getAttributeValue(ns, "uid");
        String userStr = this.parser.getAttributeValue(ns, "user");
        OSMNode node = this.ds.createNode(idStr, latStr, lonStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
        if (this.parser.nextTag() != 3 && this.parser.getName().equals("tag")) {
            this.readTags(node);
        }
        ++this.nodeReadCount;
    }

    private void readWay() throws XmlPullParserException, IOException {
        String idStr = this.parser.getAttributeValue(ns, "id");
        String versionStr = this.parser.getAttributeValue(ns, "version");
        String timestampStr = this.parser.getAttributeValue(ns, "timestamp");
        String changesetStr = this.parser.getAttributeValue(ns, "changeset");
        String uidStr = this.parser.getAttributeValue(ns, "uid");
        String userStr = this.parser.getAttributeValue(ns, "user");
        OSMWay way = this.ds.createWay(idStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
        if (this.parser.nextTag() != 3) {
            if (this.parser.getName().equals("nd")) {
                this.readNds(way);
            } else if (this.parser.getName().equals("tag")) {
                this.readTags(way);
            } else {
                this.skip();
            }
        }
        ++this.wayReadCount;
    }

    private void readRelation() throws XmlPullParserException, IOException {
        String idStr = this.parser.getAttributeValue(ns, "id");
        String versionStr = this.parser.getAttributeValue(ns, "version");
        String timestampStr = this.parser.getAttributeValue(ns, "timestamp");
        String changesetStr = this.parser.getAttributeValue(ns, "changeset");
        String uidStr = this.parser.getAttributeValue(ns, "uid");
        String userStr = this.parser.getAttributeValue(ns, "user");
        OSMRelation relation = this.ds.createRelation(idStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
        if (this.parser.nextTag() != 3) {
            if (this.parser.getName().equals("member")) {
                this.readMembers(relation);
            } else if (this.parser.getName().equals("tag")) {
                this.readTags(relation);
            } else {
                this.skip();
            }
        }
        ++this.relationReadCount;
    }

    private void readTags(OSMElement el) throws XmlPullParserException, IOException {
        String k = this.parser.getAttributeValue(ns, "k");
        String v = this.parser.getAttributeValue(ns, "v");
        el.addParsedTag(k, v);
        this.parser.nextTag();
        this.parser.nextTag();
        if (this.parser.getName().equals("tag")) {
            this.readTags(el);
        } else if (this.parser.getName().equals("nd")) {
            this.readNds((OSMWay)el);
        } else if (this.parser.getName().equals("member")) {
            this.readMembers((OSMRelation)el);
        }
        ++this.tagReadCount;
    }

    private void readNds(OSMWay way) throws XmlPullParserException, IOException {
        String ref = this.parser.getAttributeValue(ns, "ref");
        long id = Long.valueOf(ref);
        way.addNodeRef(id);
        this.parser.nextTag();
        this.parser.nextTag();
        if (this.parser.getName().equals("tag")) {
            this.readTags(way);
        } else if (this.parser.getName().equals("nd")) {
            this.readNds(way);
        }
    }

    private void readMembers(OSMRelation relation) throws XmlPullParserException, IOException {
        String type = this.parser.getAttributeValue(ns, "type");
        String ref = this.parser.getAttributeValue(ns, "ref");
        String role = this.parser.getAttributeValue(ns, "role");
        long id = Long.valueOf(ref);
        if (type.equals("node")) {
            relation.addNodeRef(id, role);
        } else if (type.equals("way")) {
            relation.addWayRef(id, role);
        } else if (type.equals("relation")) {
            relation.addRelationRef(id, role);
        }
        this.parser.nextTag();
        this.parser.nextTag();
        if (this.parser.getName().equals("tag")) {
            this.readTags(relation);
        } else if (this.parser.getName().equals("member")) {
            this.readMembers(relation);
        }
    }

    private void skip() throws XmlPullParserException, IOException {
        if (this.parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (this.parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    private String readText() throws IOException, XmlPullParserException {
        String result = "";
        if (this.parser.next() == 4) {
            result = this.parser.getText();
            this.parser.nextTag();
        }
        return result;
    }
}

