/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.model;

import com.mapbox.mapboxsdk.views.MapView;
import com.spatialdev.osm.model.OSMElement;
import com.spatialdev.osm.model.OSMNode;
import com.spatialdev.osm.model.OSMRelation;
import com.spatialdev.osm.renderer.OSMPath;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlSerializer;

public class OSMWay
extends OSMElement {
    private LinkedList<Long> nodeRefs = new LinkedList();
    private LinkedList<OSMNode> linkedNodes = new LinkedList();
    private LinkedList<OSMRelation> linkedRelations = new LinkedList();
    private boolean closed = false;

    public OSMWay(String idStr, String versionStr, String timestampStr, String changesetStr, String uidStr, String userStr) {
        super(idStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
    }

    @Override
    void xml(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(null, "way");
        if (this.isModified()) {
            xmlSerializer.attribute(null, "action", "modify");
        }
        this.setOsmElementXmlAttributes(xmlSerializer);
        this.setWayXmlNds(xmlSerializer);
        super.xml(xmlSerializer);
        xmlSerializer.endTag(null, "way");
    }

    private void setWayXmlNds(XmlSerializer xmlSerializer) throws IOException {
        for (OSMNode node : this.linkedNodes) {
            xmlSerializer.startTag(null, "nd");
            xmlSerializer.attribute(null, "ref", String.valueOf(node.getId()));
            xmlSerializer.endTag(null, "nd");
        }
    }

    public void addNodeRef(long id) {
        this.nodeRefs.add(id);
    }

    int linkNodes(Map<Long, OSMNode> nodes, Set<Long> wayNodes) {
        this.checkIfClosed();
        LinkedList<Long> unlinkedRefs = new LinkedList<Long>();
        while (this.nodeRefs.size() > 0) {
            Long refId = this.nodeRefs.pop();
            OSMNode node = nodes.get(refId);
            wayNodes.add(refId);
            if (node == null) {
                unlinkedRefs.push(refId);
                continue;
            }
            this.linkedNodes.push(node);
        }
        this.nodeRefs = unlinkedRefs;
        return this.nodeRefs.size();
    }

    public int getUnlinkedNodesCount() {
        return this.nodeRefs.size();
    }

    public int getLinkedNodesCount() {
        return this.linkedNodes.size();
    }

    private void checkIfClosed() {
        Long lastId;
        Long firstId = this.nodeRefs.getFirst();
        if (firstId.equals(lastId = this.nodeRefs.getLast())) {
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Iterator<OSMNode> getNodeIterator() {
        return this.linkedNodes.listIterator();
    }

    public List<OSMNode> getNodes() {
        return this.linkedNodes;
    }

    public void addRelation(OSMRelation relation) {
        this.linkedRelations.push(relation);
    }

    public List<OSMRelation> getRelations() {
        return this.linkedRelations;
    }

    public OSMPath getOSMPath(MapView mv) {
        if (this.osmPath == null) {
            this.osmPath = OSMPath.createOSMPath(this, mv);
        }
        return this.osmPath;
    }

    @Override
    public void select() {
        super.select();
        if (this.osmPath != null) {
            this.osmPath.select();
        }
    }

    @Override
    public void deselect() {
        super.deselect();
        if (this.osmPath != null) {
            this.osmPath.deselect();
        }
    }
}

