/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.bitmapcache;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import android.util.Log;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.co.senab.bitmapcache.BitmapLruCache;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;
import uk.co.senab.bitmapcache.SDK12;

final class BitmapMemoryLruCache
extends LruCache<String, CacheableBitmapDrawable> {
    public static final String TAG = BitmapMemoryLruCache.class.getSimpleName();
    private final Set<SoftReference<CacheableBitmapDrawable>> mRemovedEntries;
    private final BitmapLruCache.RecyclePolicy mRecyclePolicy;
    private int largestValueSeenBytes;

    BitmapMemoryLruCache(int maxSize, BitmapLruCache.RecyclePolicy policy) {
        super(maxSize);
        this.mRecyclePolicy = policy;
        this.mRemovedEntries = policy.canInBitmap() ? Collections.synchronizedSet(new HashSet()) : null;
        this.largestValueSeenBytes = 0;
    }

    CacheableBitmapDrawable put(CacheableBitmapDrawable value) {
        if (null != value) {
            value.setCached(true);
            this.largestValueSeenBytes = Math.max(value.getMemorySize(), this.largestValueSeenBytes);
            return (CacheableBitmapDrawable)((Object)this.put(value.getUrl(), (Object)value));
        }
        return null;
    }

    BitmapLruCache.RecyclePolicy getRecyclePolicy() {
        return this.mRecyclePolicy;
    }

    public void resizeMemoryForTiles(int numberOfTiles) {
        float factor;
        int newSize;
        if (this.largestValueSeenBytes > 0 && numberOfTiles > 0 && (newSize = (int)((factor = (float)numberOfTiles * 1.05f) * (float)this.largestValueSeenBytes)) > this.maxSize()) {
            Log.d((String)TAG, (String)("resizing for " + numberOfTiles + " tiles - to " + newSize / 0x100000 + "MB"));
            this.resize(newSize);
        }
    }

    protected int sizeOf(String key, CacheableBitmapDrawable value) {
        return value.getMemorySize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entryRemoved(boolean evicted, String key, CacheableBitmapDrawable oldValue, CacheableBitmapDrawable newValue) {
        oldValue.setCached(false);
        if (this.mRemovedEntries != null && BitmapMemoryLruCache.canUseForInBitmap(oldValue)) {
            Set<SoftReference<CacheableBitmapDrawable>> set = this.mRemovedEntries;
            synchronized (set) {
                this.mRemovedEntries.add(new SoftReference<CacheableBitmapDrawable>(oldValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapFromRemoved(int width, int height) {
        if (this.mRemovedEntries == null) {
            return null;
        }
        Bitmap result = null;
        Set<SoftReference<CacheableBitmapDrawable>> set = this.mRemovedEntries;
        synchronized (set) {
            Iterator<SoftReference<CacheableBitmapDrawable>> it = this.mRemovedEntries.iterator();
            while (it.hasNext()) {
                CacheableBitmapDrawable value = it.next().get();
                if (BitmapMemoryLruCache.canUseForInBitmap(value)) {
                    if (!BitmapMemoryLruCache.canUseForInBitmapForSize(value, width, height) || value.isBeingDisplayed() || value.isReferencedByCache()) continue;
                    result = value.getBitmap();
                    SDK12.setHasAlpha(result, true);
                    result.eraseColor(0);
                    value.setReused();
                    it.remove();
                    break;
                }
                it.remove();
            }
        }
        return result;
    }

    private static boolean canUseForInBitmap(CacheableBitmapDrawable candidate) {
        return candidate != null && candidate.isBitmapValid() && candidate.isBitmapMutable();
    }

    private static boolean canUseForInBitmapForSize(CacheableBitmapDrawable candidate, int width, int height) {
        return candidate.getIntrinsicWidth() == width && candidate.getIntrinsicHeight() == height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trimMemory() {
        Set values = this.snapshot().entrySet();
        for (Map.Entry entry : values) {
            CacheableBitmapDrawable value = (CacheableBitmapDrawable)((Object)entry.getValue());
            if (null != value && value.isBeingDisplayed()) continue;
            this.remove(entry.getKey());
        }
        if (this.mRemovedEntries != null) {
            Set<SoftReference<CacheableBitmapDrawable>> set = this.mRemovedEntries;
            synchronized (set) {
                this.mRemovedEntries.clear();
            }
        }
    }
}

