/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import com.mapbox.mapboxsdk.overlay.UserLocationOverlay;
import com.mapbox.mapboxsdk.util.NetworkLocationIgnorer;

public class GpsLocationProvider
implements LocationListener {
    private final LocationManager mLocationManager;
    private Location mLocation;
    private UserLocationOverlay mMyLocationConsumer;
    private long mLocationUpdateMinTime = 0L;
    private float mLocationUpdateMinDistance = 0.0f;
    private final NetworkLocationIgnorer mIgnorer = new NetworkLocationIgnorer();

    public GpsLocationProvider(Context context) {
        this.mLocationManager = (LocationManager)context.getSystemService("location");
    }

    public long getLocationUpdateMinTime() {
        return this.mLocationUpdateMinTime;
    }

    public void setLocationUpdateMinTime(long milliSeconds) {
        this.mLocationUpdateMinTime = milliSeconds;
    }

    public float getLocationUpdateMinDistance() {
        return this.mLocationUpdateMinDistance;
    }

    public void setLocationUpdateMinDistance(float meters) {
        this.mLocationUpdateMinDistance = meters;
    }

    public boolean startLocationProvider(UserLocationOverlay myLocationConsumer) {
        this.mMyLocationConsumer = myLocationConsumer;
        boolean result = false;
        for (String provider : this.mLocationManager.getProviders(true)) {
            if (!"gps".equals(provider) && !"passive".equals(provider) && !"network".equals(provider)) continue;
            result = true;
            if (this.mLocation == null) {
                this.mLocation = this.mLocationManager.getLastKnownLocation(provider);
                if (this.mLocation != null) {
                    this.mMyLocationConsumer.onLocationChanged(this.mLocation, this);
                }
            }
            this.mLocationManager.requestLocationUpdates(provider, this.mLocationUpdateMinTime, this.mLocationUpdateMinDistance, (LocationListener)this);
        }
        return result;
    }

    public void stopLocationProvider() {
        this.mMyLocationConsumer = null;
        this.mLocationManager.removeUpdates((LocationListener)this);
    }

    public Location getLastKnownLocation() {
        return this.mLocation;
    }

    public void onLocationChanged(Location location) {
        if (this.mIgnorer.shouldIgnore(location.getProvider(), System.currentTimeMillis())) {
            return;
        }
        this.mLocation = location;
        if (this.mMyLocationConsumer != null) {
            this.mMyLocationConsumer.onLocationChanged(this.mLocation, this);
        }
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }
}

