/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.squareup.okhttp.HttpResponseCache;
import com.squareup.okhttp.OkHttpClient;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;

public class NetworkUtils {
    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static HttpURLConnection getHttpURLConnection(URL url) {
        return NetworkUtils.getHttpURLConnection(url, null, null);
    }

    public static HttpURLConnection getHttpURLConnection(URL url, ResponseCache cache) {
        return NetworkUtils.getHttpURLConnection(url, cache, null);
    }

    public static HttpURLConnection getHttpURLConnection(URL url, ResponseCache cache, SSLSocketFactory sslSocketFactory) {
        OkHttpClient client = new OkHttpClient();
        if (cache != null) {
            client.setResponseCache(cache);
        }
        if (sslSocketFactory != null) {
            client.setSslSocketFactory(sslSocketFactory);
        }
        HttpURLConnection connection = client.open(url);
        connection.setRequestProperty("User-Agent", "Mapbox Android SDK/0.4.0");
        return connection;
    }

    public static ResponseCache getResponseCache(File cacheDir, int maxSize) throws IOException {
        return new HttpResponseCache(cacheDir, (long)maxSize);
    }
}

