/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import android.os.AsyncTask;
import android.util.Log;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.tileprovider.tilesource.WebSourceTileLayer;
import com.mapbox.mapboxsdk.util.NetworkUtils;
import com.mapbox.mapboxsdk.util.constants.UtilConstants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URL;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TileJsonTileLayer
extends WebSourceTileLayer {
    private JSONObject tileJSON;
    private ResponseCache cache;
    private static final String TAG = "TileJsonTileLayer";

    public TileJsonTileLayer(String pId, String url, boolean enableSSL) {
        super(pId, url, enableSSL);
        File cacheDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        try {
            this.cache = NetworkUtils.getResponseCache(cacheDir, 1024);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Cache creation failed.", (Throwable)e);
        }
        String jsonURL = this.getBrandedJSONURL();
        if (jsonURL != null) {
            this.fetchBrandedJSONAndInit(jsonURL);
        }
    }

    private void initWithTileJSON(JSONObject aTileJSON) {
        this.setTileJSON(aTileJSON != null ? aTileJSON : new JSONObject());
        if (aTileJSON != null) {
            double[] bounds;
            if (this.tileJSON.has("tiles")) {
                try {
                    this.setURL(this.tileJSON.getJSONArray("tiles").getString(0).replace(".png", "{2x}.png"));
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)"Couldn't set tile url", (Throwable)e);
                }
            }
            this.mMinimumZoomLevel = this.getJSONFloat(this.tileJSON, "minzoom");
            this.mMaximumZoomLevel = this.getJSONFloat(this.tileJSON, "maxzoom");
            this.mName = this.tileJSON.optString("name");
            this.mDescription = this.tileJSON.optString("description");
            this.mAttribution = this.tileJSON.optString("attribution");
            this.mLegend = this.tileJSON.optString("legend");
            double[] center = this.getJSONDoubleArray(this.tileJSON, "center", 3);
            if (center != null) {
                this.mCenter = new LatLng(center[0], center[1], center[2]);
            }
            if ((bounds = this.getJSONDoubleArray(this.tileJSON, "bounds", 4)) != null) {
                this.mBoundingBox = new BoundingBox(bounds[3], bounds[2], bounds[1], bounds[0]);
            }
        }
        if (UtilConstants.DEBUGMODE) {
            Log.d((String)TAG, (String)("TileJSON " + this.tileJSON.toString()));
        }
    }

    public JSONObject getTileJSON() {
        return this.tileJSON;
    }

    public void setTileJSON(JSONObject aTileJSON) {
        this.tileJSON = aTileJSON;
    }

    private float getJSONFloat(JSONObject JSON, String key) {
        float defaultValue = 0.0f;
        if (JSON.has(key)) {
            try {
                return (float)JSON.getDouble(key);
            }
            catch (JSONException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private double[] getJSONDoubleArray(JSONObject JSON, String key, int length) {
        double[] defaultValue = null;
        if (JSON.has(key)) {
            try {
                boolean valid = false;
                double[] result = new double[length];
                Object value = JSON.get(key);
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    if (array.length() == length) {
                        for (int i = 0; i < array.length(); ++i) {
                            result[i] = array.getDouble(i);
                        }
                        valid = true;
                    }
                } else {
                    String[] array = JSON.getString(key).split(",");
                    if (array.length == length) {
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = Double.parseDouble(array[i]);
                        }
                        valid = true;
                    }
                }
                if (valid) {
                    return result;
                }
            }
            catch (JSONException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    byte[] readFully(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        return out.toByteArray();
    }

    private void fetchBrandedJSONAndInit(String url) {
        new RetrieveJSONTask(){

            protected void onPostExecute(JSONObject jsonObject) {
                TileJsonTileLayer.this.initWithTileJSON(jsonObject);
            }
        }.execute(new String[]{url});
    }

    protected String getBrandedJSONURL() {
        return null;
    }

    class RetrieveJSONTask
    extends AsyncTask<String, Void, JSONObject> {
        RetrieveJSONTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONObject doInBackground(String ... urls) {
            InputStream in = null;
            try {
                URL url = new URL(urls[0]);
                HttpURLConnection connection = NetworkUtils.getHttpURLConnection(url, TileJsonTileLayer.this.cache);
                in = connection.getInputStream();
                byte[] response = TileJsonTileLayer.this.readFully(in);
                String result = new String(response, "UTF-8");
                JSONObject jSONObject = new JSONObject(result);
                return jSONObject;
            }
            catch (Exception e) {
                e.printStackTrace();
                JSONObject jSONObject = null;
                return jSONObject;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TileJsonTileLayer.TAG, (String)("Error closing InputStream: " + e.toString()));
                }
            }
        }
    }
}

