/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider;

import android.graphics.Rect;

public class MapTile {
    public static final int MAPTILE_SUCCESS_ID = 0;
    public static final int MAPTILE_FAIL_ID = 1;
    private final int x;
    private final int y;
    private final int z;
    private final String path;
    private final String cacheKey;
    private final int code;
    private Rect mTileRect;

    public MapTile(int az, int ax, int ay) {
        this("", az, ax, ay);
    }

    public MapTile(String aCacheKey, int az, int ax, int ay) {
        this.z = az;
        this.x = ax;
        this.y = ay;
        this.path = String.valueOf(this.z) + "/" + String.valueOf(this.x) + "/" + String.valueOf(this.y);
        this.cacheKey = aCacheKey + "/" + this.path;
        this.code = 17 * (37 + this.z) * (37 * this.x) * (37 + this.y);
    }

    public int getZ() {
        return this.z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MapTile)) {
            return false;
        }
        MapTile rhs = (MapTile)obj;
        return this.z == rhs.z && this.x == rhs.x && this.y == rhs.y;
    }

    public int hashCode() {
        return this.code;
    }

    public void setTileRect(Rect rect) {
        this.mTileRect = rect;
    }

    public final Rect getTileRect() {
        return this.mTileRect;
    }
}

