/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.bitmapcache;

import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.senab.bitmapcache.Constants;

class IoUtils {
    IoUtils() {
    }

    static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.i((String)Constants.LOG_TAG, (String)"Failed to close InputStream", (Throwable)e);
            }
        }
    }

    static void closeStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                Log.i((String)Constants.LOG_TAG, (String)"Failed to close OutputStream", (Throwable)e);
            }
        }
    }

    static long copy(File in, OutputStream out) throws IOException {
        return IoUtils.copy((InputStream)new FileInputStream(in), out);
    }

    static long copy(InputStream in, File out) throws IOException {
        return IoUtils.copy(in, (OutputStream)new FileOutputStream(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream input, OutputStream output) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[4096];
            long count = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            output.flush();
            long l = count;
            return l;
        }
        finally {
            IoUtils.closeStream(input);
            IoUtils.closeStream(output);
        }
    }
}

