/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import java.lang.reflect.Field;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class BitmapUtils {
    private static final String TAG = "BitmapUtils";
    public static final int[] EXPIRED = new int[]{-1};

    public static BitmapFactory.Options getBitmapOptions(DisplayMetrics mDisplayMetrics) {
        try {
            Field density = DisplayMetrics.class.getDeclaredField("DENSITY_DEFAULT");
            Field inDensity = BitmapFactory.Options.class.getDeclaredField("inDensity");
            Field inTargetDensity = BitmapFactory.Options.class.getDeclaredField("inTargetDensity");
            Field targetDensity = DisplayMetrics.class.getDeclaredField("densityDpi");
            BitmapFactory.Options options = new BitmapFactory.Options();
            inDensity.setInt(options, density.getInt(null));
            inTargetDensity.setInt(options, targetDensity.getInt(mDisplayMetrics));
            return options;
        }
        catch (IllegalAccessException ex) {
            Log.d((String)TAG, (String)"Couldn't access fields.", (Throwable)ex);
        }
        catch (NoSuchFieldException ex) {
            Log.d((String)TAG, (String)"Couldn't find fields.", (Throwable)ex);
        }
        return null;
    }

    public static boolean isCacheDrawableExpired(Drawable drawable2) {
        return drawable2 != null && drawable2.getState() == EXPIRED;
    }

    public static void setCacheDrawableExpired(CacheableBitmapDrawable drawable2) {
        if (drawable2 != null) {
            drawable2.setState(EXPIRED);
        }
    }

    public static int calculateMemoryCacheSize(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        boolean largeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClass = am.getMemoryClass();
        if (largeHeap && Build.VERSION.SDK_INT >= 11) {
            memoryClass = ActivityManagerHoneycomb.getLargeMemoryClass(am);
        }
        return 0x100000 * memoryClass / 7;
    }

    @TargetApi(value=11)
    private static class ActivityManagerHoneycomb {
        private ActivityManagerHoneycomb() {
        }

        static int getLargeMemoryClass(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }
}

