/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.Log;
import com.google.common.base.Strings;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.MapTileCache;
import com.mapbox.mapboxsdk.tileprovider.modules.MapTileDownloader;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileLayer;
import com.mapbox.mapboxsdk.tileprovider.util.StreamUtils;
import com.mapbox.mapboxsdk.util.NetworkUtils;
import com.mapbox.mapboxsdk.views.util.TileLoadedListener;
import com.mapbox.mapboxsdk.views.util.TilesLoadedListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class WebSourceTileLayer
extends TileLayer {
    private static final String TAG = "WebSourceTileLayer";
    private AtomicInteger activeThreads = new AtomicInteger(0);
    protected boolean mEnableSSL = false;
    private static final Paint compositePaint = new Paint(2);

    public WebSourceTileLayer(String pId, String url) {
        this(pId, url, false);
    }

    public WebSourceTileLayer(String pId, String url, boolean enableSSL) {
        super(pId, url);
        this.initialize(pId, url, enableSSL);
    }

    private boolean checkThreadControl() {
        return this.activeThreads.get() == 0;
    }

    @Override
    public TileLayer setURL(String aUrl) {
        Object[] objectArray = new Object[1];
        Object object = objectArray[0] = this.mEnableSSL ? "" : "s";
        if (aUrl.contains(String.format("http%s://", objectArray))) {
            super.setURL(aUrl.replace(String.format("http%s://", this.mEnableSSL ? "" : "s"), String.format("http%s://", this.mEnableSSL ? "s" : "")));
        } else {
            super.setURL(aUrl);
        }
        return this;
    }

    protected void initialize(String pId, String aUrl, boolean enableSSL) {
        this.mEnableSSL = enableSSL;
        this.setURL(aUrl);
    }

    public String[] getTileURLs(MapTile aTile, boolean hdpi) {
        String url = this.getTileURL(aTile, hdpi);
        if (!Strings.isNullOrEmpty((String)url)) {
            return new String[]{url};
        }
        return null;
    }

    public String getTileURL(MapTile aTile, boolean hdpi) {
        return this.parseUrlForTile(this.mUrl, aTile, hdpi);
    }

    protected String parseUrlForTile(String url, MapTile aTile, boolean hdpi) {
        return url.replace("{z}", String.valueOf(aTile.getZ())).replace("{x}", String.valueOf(aTile.getX())).replace("{y}", String.valueOf(aTile.getY())).replace("{2x}", hdpi ? "@2x" : "");
    }

    private Bitmap compositeBitmaps(Bitmap source, Bitmap dest) {
        Canvas canvas = new Canvas(dest);
        canvas.drawBitmap(source, 0.0f, 0.0f, compositePaint);
        return dest;
    }

    public CacheableBitmapDrawable getDrawableFromTile(MapTileDownloader downloader, MapTile aTile, boolean hdpi) {
        if (downloader.isNetworkAvailable()) {
            TilesLoadedListener listener = downloader.getTilesLoadedListener();
            String[] urls = this.getTileURLs(aTile, hdpi);
            CacheableBitmapDrawable result = null;
            Bitmap resultBitmap = null;
            if (urls != null) {
                MapTileCache cache = downloader.getCache();
                if (listener != null) {
                    listener.onTilesLoadStarted();
                }
                for (String url : urls) {
                    Bitmap bitmap = this.getBitmapFromURL(url, cache);
                    if (bitmap == null) continue;
                    resultBitmap = resultBitmap == null ? bitmap : this.compositeBitmaps(bitmap, resultBitmap);
                }
                if (resultBitmap != null) {
                    result = cache.putTileBitmap(aTile, resultBitmap);
                }
                if (this.checkThreadControl() && listener != null) {
                    listener.onTilesLoaded();
                }
            }
            if (result != null) {
                TileLoadedListener listener2 = downloader.getTileLoadedListener();
                result = listener2 != null ? listener2.onTileLoaded(result) : result;
            }
            return result;
        }
        Log.d((String)TAG, (String)("Skipping tile " + aTile.toString() + " due to NetworkAvailabilityCheck."));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bitmap getBitmapFromURL(String url, MapTileCache aCache) {
        Bitmap bitmap;
        BufferedOutputStream out;
        InputStream in;
        block6: {
            Log.d((String)this.getClass().getCanonicalName(), (String)("getBitmapFormURL() called with url = '" + url + "'"));
            this.activeThreads.incrementAndGet();
            in = null;
            out = null;
            if (TextUtils.isEmpty((CharSequence)url)) {
                this.activeThreads.decrementAndGet();
                return null;
            }
            HttpURLConnection connection = NetworkUtils.getHttpURLConnection(new URL(url));
            in = connection.getInputStream();
            if (in != null) break block6;
            Log.d((String)TAG, (String)("No content downloading MapTile: '" + url + "'"));
            Bitmap bitmap2 = null;
            StreamUtils.closeStream(in);
            StreamUtils.closeStream(out);
            this.activeThreads.decrementAndGet();
            return bitmap2;
        }
        try {
            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
            out = new BufferedOutputStream(dataStream, 8192);
            StreamUtils.copy(in, out);
            ((OutputStream)out).flush();
            byte[] data = dataStream.toByteArray();
            bitmap = aCache.decodeBitmap(data, null);
        }
        catch (Throwable e) {
            try {
                Log.e((String)TAG, (String)("Error downloading MapTile: " + url + ":" + e));
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(in);
                StreamUtils.closeStream(out);
                this.activeThreads.decrementAndGet();
                throw throwable;
            }
            StreamUtils.closeStream(in);
            StreamUtils.closeStream(out);
            this.activeThreads.decrementAndGet();
            return null;
        }
        StreamUtils.closeStream(in);
        StreamUtils.closeStream(out);
        this.activeThreads.decrementAndGet();
        return bitmap;
    }
}

