/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import com.google.common.base.Strings;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileJsonTileLayer;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileLayer;
import com.mapbox.mapboxsdk.views.util.constants.MapViewConstants;
import java.util.Locale;

public class MapboxTileLayer
extends TileJsonTileLayer
implements MapViewConstants,
MapboxConstants {
    private static final String TAG = "MapboxTileLayer";
    private String mId;

    public MapboxTileLayer(String pId) {
        this(pId, true);
    }

    public MapboxTileLayer(String pId, boolean enableSSL) {
        super(pId, pId, enableSSL);
    }

    @Override
    protected void initialize(String pId, String aUrl, boolean enableSSL) {
        this.mId = pId;
        super.initialize(pId, aUrl, enableSSL);
    }

    @Override
    public TileLayer setURL(String aUrl) {
        if (!(Strings.isNullOrEmpty((String)aUrl) || aUrl.toLowerCase(Locale.US).contains("http://") || aUrl.toLowerCase(Locale.US).contains("https://"))) {
            super.setURL("https://a.tiles.mapbox.com/v3/" + aUrl + "/{z}/{x}/{y}{2x}.png");
        } else {
            super.setURL(aUrl);
        }
        return this;
    }

    @Override
    protected String getBrandedJSONURL() {
        return String.format("http%s://api.tiles.mapbox.com/v3/%s.json%s", this.mEnableSSL ? "s" : "", this.mId, this.mEnableSSL ? "?secure" : "");
    }

    @Override
    public String getCacheKey() {
        return this.mId;
    }
}

