/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.location.Location;
import android.util.Log;
import android.view.MotionEvent;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.events.MapListener;
import com.mapbox.mapboxsdk.events.ScrollEvent;
import com.mapbox.mapboxsdk.events.ZoomEvent;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.GpsLocationProvider;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.overlay.SafeDrawOverlay;
import com.mapbox.mapboxsdk.util.constants.UtilConstants;
import com.mapbox.mapboxsdk.views.MapController;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.safecanvas.ISafeCanvas;
import com.mapbox.mapboxsdk.views.safecanvas.SafePaint;
import com.mapbox.mapboxsdk.views.util.Projection;
import java.util.LinkedList;

public class UserLocationOverlay
extends SafeDrawOverlay
implements Overlay.Snappable,
MapListener {
    private final SafePaint mPaint = new SafePaint();
    private final SafePaint mCirclePaint = new SafePaint();
    protected final MapView mMapView;
    protected final Context mContext;
    private final MapController mMapController;
    public GpsLocationProvider mMyLocationProvider;
    private final LinkedList<Runnable> mRunOnFirstFix = new LinkedList();
    private final PointF mMapCoords = new PointF();
    private Location mLocation;
    private LatLng mLatLng;
    private boolean mIsLocationEnabled = false;
    private boolean mDrawAccuracyEnabled = true;
    private TrackingMode mTrackingMode = TrackingMode.NONE;
    private boolean mZoomBasedOnAccuracy = true;
    private float mRequiredZoomLevel = 10.0f;
    private final RectF mMyLocationRect = new RectF();
    private final RectF mMyLocationPreviousRect = new RectF();
    private Bitmap mPersonBitmap;
    private Bitmap mDirectionArrowBitmap;
    private PointF mPersonHotspot;
    private PointF mDirectionHotspot;
    private static final String TAG = "UserLocationOverlay";

    public void setDirectionArrowBitmap(Bitmap bitmap) {
        this.mDirectionArrowBitmap = bitmap;
    }

    public void setPersonBitmap(Bitmap bitmap) {
        this.mPersonBitmap = bitmap;
    }

    public void setDirectionArrowHotspot(PointF point) {
        this.mDirectionHotspot = point;
    }

    public void setPersonHotspot(PointF point) {
        this.mPersonHotspot = point;
    }

    public UserLocationOverlay(GpsLocationProvider myLocationProvider, MapView mapView, int arrowId, int personId) {
        this.mMapView = mapView;
        this.mMapController = mapView.getController();
        this.mContext = mapView.getContext();
        this.mCirclePaint.setARGB(0, 100, 100, 255);
        this.mCirclePaint.setAntiAlias(true);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setFilterBitmap(true);
        this.mPersonHotspot = new PointF(0.5f, 0.5f);
        this.mDirectionHotspot = new PointF(0.5f, 0.5f);
        if (personId != 0) {
            this.mPersonBitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)personId);
        }
        if (arrowId != 0) {
            this.mDirectionArrowBitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)arrowId);
        }
        this.setMyLocationProvider(myLocationProvider);
    }

    public UserLocationOverlay(GpsLocationProvider myLocationProvider, MapView mapView) {
        this(myLocationProvider, mapView, R.drawable.direction_arrow, R.drawable.location_marker);
    }

    @Override
    public void onDetach(MapView mapView) {
        this.disableMyLocation();
        super.onDetach(mapView);
    }

    public void setDrawAccuracyEnabled(boolean drawAccuracyEnabled) {
        this.mDrawAccuracyEnabled = drawAccuracyEnabled;
    }

    public boolean isDrawAccuracyEnabled() {
        return this.mDrawAccuracyEnabled;
    }

    public GpsLocationProvider getMyLocationProvider() {
        return this.mMyLocationProvider;
    }

    protected void setMyLocationProvider(GpsLocationProvider myLocationProvider) {
        if (this.mMyLocationProvider != null) {
            this.mMyLocationProvider.stopLocationProvider();
        }
        this.mMyLocationProvider = myLocationProvider;
    }

    protected void drawMyLocation(ISafeCanvas canvas, MapView mapView, Location lastFix) {
        Rect mapBounds = new Rect(0, 0, mapView.getMeasuredWidth(), mapView.getMeasuredHeight());
        Projection projection = mapView.getProjection();
        Rect rect = new Rect();
        this.getDrawingBounds(projection, lastFix, null).round(rect);
        if (!Rect.intersects((Rect)mapBounds, (Rect)rect)) {
            return;
        }
        projection.toMapPixels(this.mLatLng, this.mMapCoords);
        float mapScale = 1.0f / mapView.getScale();
        canvas.save();
        canvas.scale(mapScale, mapScale, this.mMapCoords.x, this.mMapCoords.y);
        if (this.mDrawAccuracyEnabled) {
            float radius = lastFix.getAccuracy() / (float)Projection.groundResolution(lastFix.getLatitude(), mapView.getZoomLevel()) * mapView.getScale();
            canvas.save();
            canvas.rotate(lastFix.getBearing(), this.mMapCoords.x, this.mMapCoords.y);
            this.mCirclePaint.setAlpha(50);
            this.mCirclePaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle(this.mMapCoords.x, this.mMapCoords.y, radius, this.mCirclePaint);
            this.mCirclePaint.setAlpha(150);
            this.mCirclePaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle(this.mMapCoords.x, this.mMapCoords.y, radius, this.mCirclePaint);
            canvas.restore();
        }
        if (UtilConstants.DEBUGMODE) {
            float tx = this.mMapCoords.x + 50.0f;
            float ty = this.mMapCoords.y - 20.0f;
            canvas.drawText("Lat: " + lastFix.getLatitude(), tx, ty + 5.0f, this.mPaint);
            canvas.drawText("Lon: " + lastFix.getLongitude(), tx, ty + 20.0f, this.mPaint);
            canvas.drawText("Alt: " + lastFix.getAltitude(), tx, ty + 35.0f, this.mPaint);
            canvas.drawText("Acc: " + lastFix.getAccuracy(), tx, ty + 50.0f, this.mPaint);
        }
        if (lastFix.hasBearing()) {
            canvas.save();
            canvas.rotate(lastFix.getBearing(), this.mMapCoords.x, this.mMapCoords.y);
            canvas.translate((float)(-this.mDirectionArrowBitmap.getWidth()) * this.mDirectionHotspot.x, (float)(-this.mDirectionArrowBitmap.getHeight()) * this.mDirectionHotspot.y);
            canvas.drawBitmap(this.mDirectionArrowBitmap, this.mMapCoords.x, this.mMapCoords.y, this.mPaint);
            canvas.restore();
        } else {
            canvas.save();
            canvas.rotate(-this.mMapView.getMapOrientation(), this.mMapCoords.x, this.mMapCoords.y);
            canvas.translate((float)(-this.mPersonBitmap.getWidth()) * this.mPersonHotspot.x, (float)(-this.mPersonBitmap.getHeight()) * this.mPersonHotspot.y);
            canvas.drawBitmap(this.mPersonBitmap, this.mMapCoords.x, this.mMapCoords.y, this.mPaint);
            canvas.restore();
        }
        canvas.restore();
    }

    public PointF getPositionOnScreen(Projection projection, PointF reuse) {
        if (reuse == null) {
            reuse = new PointF();
        }
        projection.toPixels(this.mLatLng, reuse);
        return reuse;
    }

    public PointF getDrawingPositionOnScreen(Projection projection, Location lastFix, PointF reuse) {
        reuse = this.getPositionOnScreen(projection, reuse);
        if (lastFix.hasBearing()) {
            reuse.offset(this.mPersonHotspot.x * (float)this.mPersonBitmap.getWidth(), this.mPersonHotspot.y * (float)this.mPersonBitmap.getWidth());
        } else {
            reuse.offset(this.mDirectionHotspot.x * (float)this.mDirectionArrowBitmap.getWidth(), this.mDirectionHotspot.y * (float)this.mDirectionArrowBitmap.getWidth());
        }
        return reuse;
    }

    protected RectF getDrawingBounds(Projection projection, Location lastFix, RectF reuse) {
        PointF positionOnScreen = this.getPositionOnScreen(projection, null);
        return this.getDrawingBounds(positionOnScreen, lastFix, reuse);
    }

    protected RectF getDrawingBounds(PointF positionOnScreen, Location lastFix, RectF reuse) {
        if (reuse == null) {
            reuse = new RectF();
        }
        Bitmap bitmap = lastFix.hasBearing() ? this.mDirectionArrowBitmap : this.mPersonBitmap;
        PointF scale = lastFix.hasBearing() ? this.mDirectionHotspot : this.mPersonHotspot;
        int w = (int)(Math.sqrt(2.0) * (double)Math.max(bitmap.getWidth(), bitmap.getHeight()));
        float x = positionOnScreen.x - scale.x * (float)w;
        float y = positionOnScreen.y - scale.y * (float)w;
        reuse.set(x, y, x + (float)w, y + (float)w);
        return reuse;
    }

    protected RectF getMyLocationMapDrawingBounds(MapView mv, Location lastFix, RectF reuse) {
        mv.getProjection().toMapPixels(this.mLatLng, this.mMapCoords);
        reuse = this.getDrawingBounds(this.mMapCoords, lastFix, reuse);
        if (this.mDrawAccuracyEnabled) {
            float radius = (float)Math.ceil(lastFix.getAccuracy() / (float)Projection.groundResolution(lastFix.getLatitude(), this.mMapView.getZoomLevel()));
            RectF accuracyRect = new RectF(this.mMapCoords.x - radius, this.mMapCoords.y - radius, this.mMapCoords.x + radius, this.mMapCoords.y + radius);
            float strokeWidth = (float)Math.ceil(this.mCirclePaint.getStrokeWidth() == 0.0f ? 1.0 : (double)this.mCirclePaint.getStrokeWidth());
            accuracyRect.inset(-strokeWidth, -strokeWidth);
            reuse.union(accuracyRect);
        }
        return reuse;
    }

    @Override
    protected void drawSafe(ISafeCanvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mLocation != null && this.isMyLocationEnabled()) {
            this.drawMyLocation(canvas, mapView, this.mLocation);
        }
    }

    @Override
    public boolean onSnapToItem(int x, int y, Point snapPoint, MapView mapView) {
        if (this.mLocation != null) {
            boolean snap;
            snapPoint.x = (int)this.mMapCoords.x;
            snapPoint.y = (int)this.mMapCoords.y;
            double xDiff = (float)x - this.mMapCoords.x;
            double yDiff = (float)y - this.mMapCoords.y;
            boolean bl = snap = xDiff * xDiff + yDiff * yDiff < 64.0;
            if (UtilConstants.DEBUGMODE) {
                Log.d((String)TAG, (String)("snap=" + snap));
            }
            return snap;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (event.getAction() == 2) {
            this.disableFollowLocation();
        }
        return super.onTouchEvent(event, mapView);
    }

    public LatLng getMyLocation() {
        return this.mLatLng;
    }

    public Location getLastFix() {
        return this.mLocation;
    }

    public void enableFollowLocation() {
        if (this.mTrackingMode == TrackingMode.NONE) {
            this.mTrackingMode = TrackingMode.FOLLOW;
        }
        if (this.isMyLocationEnabled()) {
            this.updateMyLocation(this.mMyLocationProvider.getLastKnownLocation());
        }
    }

    public void disableFollowLocation() {
        this.mTrackingMode = TrackingMode.NONE;
    }

    public void setTrackingMode(TrackingMode mode) {
        this.mTrackingMode = mode;
        if (this.mTrackingMode != TrackingMode.NONE && this.isMyLocationEnabled()) {
            this.updateMyLocation(this.mMyLocationProvider.getLastKnownLocation());
        }
    }

    public void setRequiredZoom(float zoomLevel) {
        this.mRequiredZoomLevel = zoomLevel;
        this.mZoomBasedOnAccuracy = false;
    }

    public TrackingMode getTrackingMode() {
        return this.mTrackingMode;
    }

    public boolean isFollowLocationEnabled() {
        return this.mTrackingMode != TrackingMode.NONE;
    }

    private void updateDrawingPositionRect() {
        this.getMyLocationMapDrawingBounds(this.mMapView, this.mLocation, this.mMyLocationRect);
    }

    private void invalidate() {
        if (this.mMapView == null) {
            return;
        }
        this.mMyLocationPreviousRect.set(this.mMyLocationRect);
        this.updateDrawingPositionRect();
        final RectF newRect = new RectF(this.mMyLocationRect);
        newRect.union(this.mMyLocationPreviousRect);
        this.mMapView.post(new Runnable(){

            @Override
            public void run() {
                UserLocationOverlay.this.mMapView.invalidateMapCoordinates(newRect);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLocationChanged(Location location, GpsLocationProvider source) {
        if (this.mLocation != null && this.mLocation.getBearing() == location.getBearing() && this.mLocation.distanceTo(location) == 0.0f) {
            return;
        }
        this.updateMyLocation(location);
        LinkedList<Runnable> linkedList = this.mRunOnFirstFix;
        synchronized (linkedList) {
            for (Runnable runnable : this.mRunOnFirstFix) {
                new Thread(runnable).start();
            }
            this.mRunOnFirstFix.clear();
        }
    }

    public boolean enableMyLocation(GpsLocationProvider myLocationProvider) {
        this.setMyLocationProvider(myLocationProvider);
        this.mIsLocationEnabled = false;
        return this.enableMyLocation();
    }

    public boolean goToMyPosition(boolean animated) {
        if (this.mLocation == null) {
            return false;
        }
        float currentZoom = this.mMapView.getZoomLevel(false);
        if (currentZoom <= this.mRequiredZoomLevel) {
            double requiredZoom = this.mRequiredZoomLevel;
            if (this.mZoomBasedOnAccuracy && this.mMapView.isLayedOut()) {
                double delta = (double)(this.mLocation.getAccuracy() / 110000.0f) * 1.2;
                Projection projection = this.mMapView.getProjection();
                LatLng desiredSouthWest = new LatLng(this.mLocation.getLatitude() - delta, this.mLocation.getLongitude() - delta);
                LatLng desiredNorthEast = new LatLng(this.mLocation.getLatitude() + delta, this.mLocation.getLongitude() + delta);
                float pixelRadius = Math.min(this.mMapView.getMeasuredWidth(), this.mMapView.getMeasuredHeight()) / 2;
                BoundingBox currentBox = projection.getBoundingBox();
                if (desiredNorthEast.getLatitude() != currentBox.getLatNorth() || desiredNorthEast.getLongitude() != currentBox.getLonEast() || desiredSouthWest.getLatitude() != currentBox.getLatSouth() || desiredSouthWest.getLongitude() != currentBox.getLonWest()) {
                    this.mMapView.zoomToBoundingBox(new BoundingBox(desiredNorthEast, desiredSouthWest), true, animated, true);
                }
            } else {
                if (animated) {
                    return this.mMapController.setZoomAnimated((float)requiredZoom, this.mLatLng, true, false);
                }
                this.mMapController.setZoom((float)requiredZoom, this.mLatLng, false);
            }
        } else {
            if (animated) {
                return this.mMapController.animateTo(this.mLatLng);
            }
            return this.mMapController.goTo(this.mLatLng, null);
        }
        return true;
    }

    private void updateMyLocation(Location location) {
        this.mLocation = location;
        if (this.mLocation == null) {
            this.mLatLng = null;
            return;
        }
        this.mLatLng = new LatLng(this.mLocation);
        if (!this.isFollowLocationEnabled() || !this.goToMyPosition(true)) {
            this.invalidate();
        }
    }

    public boolean enableMyLocation() {
        boolean result;
        if (this.mIsLocationEnabled) {
            this.mMyLocationProvider.stopLocationProvider();
        }
        this.mIsLocationEnabled = result = this.mMyLocationProvider.startLocationProvider(this);
        if (result) {
            this.updateMyLocation(this.mMyLocationProvider.getLastKnownLocation());
        }
        return result;
    }

    public void disableMyLocation() {
        this.mIsLocationEnabled = false;
        if (this.mMyLocationProvider != null) {
            this.mMyLocationProvider.stopLocationProvider();
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    public boolean isMyLocationEnabled() {
        return this.mIsLocationEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runOnFirstFix(Runnable runnable) {
        if (this.mMyLocationProvider != null && this.mLocation != null) {
            new Thread(runnable).start();
            return true;
        }
        LinkedList<Runnable> linkedList = this.mRunOnFirstFix;
        synchronized (linkedList) {
            this.mRunOnFirstFix.addLast(runnable);
        }
        return false;
    }

    @Override
    public void onScroll(ScrollEvent event) {
        if (event.getUserAction()) {
            this.disableFollowLocation();
        }
    }

    @Override
    public void onZoom(ZoomEvent event) {
        if (event.getUserAction()) {
            this.disableFollowLocation();
        }
    }

    public static enum TrackingMode {
        NONE,
        FOLLOW,
        FOLLOW_BEARING;

    }
}

