/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.format;

import android.graphics.Paint;
import android.util.Log;
import com.google.common.base.Strings;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.Icon;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.overlay.PathOverlay;
import com.mapbox.mapboxsdk.views.MapView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeoJSON {
    public static List<Object> parseString(String jsonString, MapView mv) throws JSONException {
        return GeoJSON.parse(new JSONObject(jsonString), mv);
    }

    public static List<Object> parse(JSONObject json, MapView mv) throws JSONException {
        ArrayList<Object> uiObjects = new ArrayList<Object>();
        String type = json.optString("type");
        if (Strings.isNullOrEmpty((String)type)) {
            Log.w((String)GeoJSON.class.getCanonicalName(), (String)"type is null, so returning.");
            return uiObjects;
        }
        if (type.equals("FeatureCollection")) {
            uiObjects.addAll(GeoJSON.featureCollectionToLayers(json, mv));
        } else if (type.equals("Feature")) {
            uiObjects.addAll(GeoJSON.featureToLayer(json, mv));
        } else if (type.equals("Polygon") || type.equals("MultiPolygon") || type.equals("Point") || type.equals("MultiPoint") || type.equals("LineString") || type.equals("MultiLineString") || type.equals("GeometryCollection")) {
            uiObjects.addAll(GeoJSON.parseGeometry(json, null, mv, ""));
        }
        return uiObjects;
    }

    public static ArrayList<Object> featureCollectionToLayers(JSONObject featureCollection, MapView mv) throws JSONException {
        ArrayList<Object> uiObjects = new ArrayList<Object>();
        JSONArray features = (JSONArray)featureCollection.get("features");
        for (int i = 0; i < features.length(); ++i) {
            uiObjects.addAll(GeoJSON.featureToLayer((JSONObject)features.get(i), mv));
        }
        return uiObjects;
    }

    public static List<Object> featureToLayer(JSONObject feature, MapView mv) throws JSONException {
        ArrayList<Object> uiObjects = new ArrayList<Object>();
        JSONObject properties = (JSONObject)feature.get("properties");
        String title = properties.optString("title");
        JSONObject geometry = (JSONObject)feature.get("geometry");
        if (Strings.isNullOrEmpty((String)geometry.optString("type"))) {
            Log.w((String)GeoJSON.class.getCanonicalName(), (String)"type is null, so can't parse anything.");
            return uiObjects;
        }
        Icon markerIcon = null;
        String markerColor = properties.optString("marker-color");
        String markerSize = properties.optString("marker-size");
        String markerSymbol = properties.optString("marker-symbol");
        if (!(Strings.isNullOrEmpty((String)markerColor) && Strings.isNullOrEmpty((String)markerSize) && Strings.isNullOrEmpty((String)markerSymbol))) {
            Icon.Size size;
            try {
                size = Icon.Size.valueOf(markerSize.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException iae) {
                size = Icon.Size.LARGE;
            }
            markerIcon = new Icon(mv.getContext(), size, markerSymbol, markerColor);
        }
        return GeoJSON.parseGeometry(geometry, markerIcon, mv, title);
    }

    private static ArrayList<Object> parseGeometry(JSONObject geometry, Icon markerIcon, MapView mv, String title) throws JSONException {
        ArrayList<Object> uiObjects;
        block18: {
            String type;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                type = geometry.optString("type");
                                uiObjects = new ArrayList<Object>();
                                if (!type.equals("Point")) break block17;
                                JSONArray coordinates = (JSONArray)geometry.get("coordinates");
                                double lon = (Double)coordinates.get(0);
                                double lat = (Double)coordinates.get(1);
                                Marker marker = new Marker(mv, title, "", new LatLng(lat, lon));
                                if (markerIcon != null) {
                                    marker.setIcon(markerIcon);
                                }
                                uiObjects.add(marker);
                                break block18;
                            }
                            if (!type.equals("MultiPoint")) break block19;
                            JSONArray points = (JSONArray)geometry.get("coordinates");
                            for (int j = 0; j < points.length(); ++j) {
                                JSONArray coordinates = (JSONArray)points.get(j);
                                double lon = (Double)coordinates.get(0);
                                double lat = (Double)coordinates.get(1);
                                Marker marker = new Marker(mv, title, "", new LatLng(lat, lon));
                                if (markerIcon != null) {
                                    marker.setIcon(markerIcon);
                                }
                                uiObjects.add(marker);
                            }
                            break block18;
                        }
                        if (!type.equals("LineString")) break block20;
                        PathOverlay path = new PathOverlay();
                        JSONArray points = (JSONArray)geometry.get("coordinates");
                        for (int j = 0; j < points.length(); ++j) {
                            JSONArray coordinates = (JSONArray)points.get(j);
                            double lon = (Double)coordinates.get(0);
                            double lat = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat, lon));
                        }
                        uiObjects.add(path);
                        break block18;
                    }
                    if (!type.equals("MultiLineString")) break block21;
                    JSONArray lines = (JSONArray)geometry.get("coordinates");
                    for (int k = 0; k < lines.length(); ++k) {
                        PathOverlay path = new PathOverlay();
                        JSONArray points = (JSONArray)lines.get(k);
                        for (int j = 0; j < points.length(); ++j) {
                            JSONArray coordinates = (JSONArray)points.get(j);
                            double lon = (Double)coordinates.get(0);
                            double lat = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat, lon));
                        }
                        uiObjects.add(path);
                    }
                    break block18;
                }
                if (!type.equals("Polygon")) break block22;
                PathOverlay path = new PathOverlay();
                path.getPaint().setStyle(Paint.Style.FILL);
                JSONArray points = (JSONArray)geometry.get("coordinates");
                for (int r = 0; r < points.length(); ++r) {
                    double lat;
                    double lon;
                    JSONArray coordinates;
                    int j;
                    JSONArray ring = (JSONArray)points.get(r);
                    if (r == 0 && !GeoJSON.windingOrder(ring) || r != 0 && GeoJSON.windingOrder(ring)) {
                        for (j = 0; j < ring.length(); ++j) {
                            coordinates = (JSONArray)ring.get(j);
                            lon = (Double)coordinates.get(0);
                            lat = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat, lon));
                        }
                    } else {
                        for (j = ring.length() - 1; j >= 0; --j) {
                            coordinates = (JSONArray)ring.get(j);
                            lon = (Double)coordinates.get(0);
                            lat = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat, lon));
                        }
                    }
                    uiObjects.add(path);
                }
                break block18;
            }
            if (!type.equals("MultiPolygon")) break block18;
            PathOverlay path = new PathOverlay();
            path.getPaint().setStyle(Paint.Style.FILL);
            JSONArray polygons = (JSONArray)geometry.get("coordinates");
            for (int p = 0; p < polygons.length(); ++p) {
                JSONArray points = (JSONArray)polygons.get(p);
                for (int r = 0; r < points.length(); ++r) {
                    double lat;
                    double lon;
                    JSONArray coordinates;
                    int j;
                    JSONArray ring = (JSONArray)points.get(r);
                    if (r == 0 && !GeoJSON.windingOrder(ring) || r != 0 && GeoJSON.windingOrder(ring)) {
                        for (j = 0; j < ring.length(); ++j) {
                            coordinates = (JSONArray)ring.get(j);
                            lon = (Double)coordinates.get(0);
                            lat = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat, lon));
                        }
                    } else {
                        for (j = ring.length() - 1; j >= 0; --j) {
                            coordinates = (JSONArray)ring.get(j);
                            lon = (Double)coordinates.get(0);
                            lat = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat, lon));
                        }
                    }
                    uiObjects.add(path);
                }
            }
        }
        return uiObjects;
    }

    private static boolean windingOrder(JSONArray ring) throws JSONException {
        float area = 0.0f;
        if (ring.length() > 2) {
            for (int i = 0; i < ring.length() - 1; ++i) {
                JSONArray p1 = (JSONArray)ring.get(i);
                JSONArray p2 = (JSONArray)ring.get(i + 1);
                area = (float)((double)area + GeoJSON.rad((Double)p2.get(0) - (Double)p1.get(0)) * (2.0 + Math.sin(GeoJSON.rad((Double)p1.get(1))) + Math.sin(GeoJSON.rad((Double)p2.get(1)))));
            }
        }
        return area > 0.0f;
    }

    private static double rad(double _) {
        return _ * Math.PI / 180.0;
    }
}

