/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.picker.ui;

import android.animation.TimeInterpolator;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import android.widget.ImageView;
import com.google.gson.JsonObject;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.places.R;
import com.mapbox.mapboxsdk.plugins.places.common.utils.ColorUtils;
import com.mapbox.mapboxsdk.plugins.places.picker.model.PlacePickerOptions;
import com.mapbox.mapboxsdk.plugins.places.picker.ui.CurrentPlaceSelectionBottomSheet;
import com.mapbox.mapboxsdk.plugins.places.picker.viewmodel.PlacePickerViewModel;
import java.util.Locale;
import timber.log.Timber;

public class PlacePickerActivity
extends AppCompatActivity
implements OnMapReadyCallback,
MapboxMap.OnCameraMoveStartedListener,
MapboxMap.OnCameraIdleListener,
Observer<CarmenFeature> {
    CurrentPlaceSelectionBottomSheet bottomSheet;
    CarmenFeature carmenFeature;
    private PlacePickerViewModel viewModel;
    private PlacePickerOptions options;
    private ImageView markerImage;
    private MapboxMap mapboxMap;
    private String accessToken;
    private MapView mapView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(8);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
        this.setContentView(R.layout.mapbox_activity_place_picker);
        if (savedInstanceState == null) {
            this.accessToken = this.getIntent().getStringExtra("com.mapbox.mapboxsdk.plugins.places.accessToken");
            this.options = (PlacePickerOptions)this.getIntent().getParcelableExtra("com.mapbox.mapboxsdk.plugins.places.placeOptions");
        }
        this.viewModel = (PlacePickerViewModel)ViewModelProviders.of((FragmentActivity)this).get(PlacePickerViewModel.class);
        this.viewModel.getResults().observe((LifecycleOwner)this, (Observer)this);
        this.bindViews();
        this.addBackButtonListener();
        this.addChosenLocationButton();
        this.customizeViews();
        this.mapView.onCreate(savedInstanceState);
        this.mapView.getMapAsync((OnMapReadyCallback)this);
    }

    private void addBackButtonListener() {
        ImageView backButton = (ImageView)this.findViewById(R.id.mapbox_place_picker_toolbar_back_button);
        backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PlacePickerActivity.this.finish();
            }
        });
    }

    private void bindViews() {
        this.mapView = (MapView)this.findViewById(R.id.map_view);
        this.bottomSheet = (CurrentPlaceSelectionBottomSheet)this.findViewById(R.id.mapbox_plugins_picker_bottom_sheet);
        this.markerImage = (ImageView)this.findViewById(R.id.mapbox_plugins_image_view_marker);
    }

    private void customizeViews() {
        ConstraintLayout toolbar = (ConstraintLayout)this.findViewById(R.id.place_picker_toolbar);
        if (this.options != null && this.options.toolbarColor() != null) {
            toolbar.setBackgroundColor(this.options.toolbarColor().intValue());
        } else {
            int color2 = ColorUtils.getMaterialColor((Context)this, R.attr.colorPrimary);
            toolbar.setBackgroundColor(color2);
        }
    }

    public void onMapReady(final MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
        mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", new Style.OnStyleLoaded(){

            public void onStyleLoaded(@NonNull Style style) {
                if (PlacePickerActivity.this.options != null) {
                    if (PlacePickerActivity.this.options.startingBounds() != null) {
                        mapboxMap.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)PlacePickerActivity.this.options.startingBounds(), (int)0));
                    } else if (PlacePickerActivity.this.options.statingCameraPosition() != null) {
                        mapboxMap.moveCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)PlacePickerActivity.this.options.statingCameraPosition()));
                    }
                }
                PlacePickerActivity.this.makeReverseGeocodingSearch();
                PlacePickerActivity.this.mapboxMap.addOnCameraMoveStartedListener((MapboxMap.OnCameraMoveStartedListener)PlacePickerActivity.this);
                PlacePickerActivity.this.mapboxMap.addOnCameraIdleListener((MapboxMap.OnCameraIdleListener)PlacePickerActivity.this);
            }
        });
    }

    public void onCameraMoveStarted(int reason) {
        Timber.v((String)"Map camera has begun moving.", (Object[])new Object[0]);
        if (this.markerImage.getTranslationY() == 0.0f) {
            this.markerImage.animate().translationY(-75.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator()).setDuration(250L).start();
            if (this.bottomSheet.isShowing()) {
                this.bottomSheet.dismissPlaceDetails();
            }
        }
    }

    public void onCameraIdle() {
        Timber.v((String)"Map camera is now idling.", (Object[])new Object[0]);
        this.markerImage.animate().translationY(0.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator()).setDuration(250L).start();
        this.bottomSheet.setPlaceDetails(null);
        this.makeReverseGeocodingSearch();
    }

    public void onChanged(@Nullable CarmenFeature carmenFeature) {
        if (carmenFeature == null) {
            carmenFeature = CarmenFeature.builder().placeName(String.format(Locale.US, "[%f, %f]", this.mapboxMap.getCameraPosition().target.getLatitude(), this.mapboxMap.getCameraPosition().target.getLongitude())).text("No address found").properties(new JsonObject()).build();
        }
        this.carmenFeature = carmenFeature;
        this.bottomSheet.setPlaceDetails(carmenFeature);
    }

    private void makeReverseGeocodingSearch() {
        LatLng latLng = this.mapboxMap.getCameraPosition().target;
        this.viewModel.reverseGeocode(Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()), this.accessToken, this.options);
    }

    private void addChosenLocationButton() {
        FloatingActionButton placeSelectedButton = (FloatingActionButton)this.findViewById(R.id.place_chosen_button);
        placeSelectedButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PlacePickerActivity.this.carmenFeature == null) {
                    Snackbar.make((View)PlacePickerActivity.this.bottomSheet, (CharSequence)PlacePickerActivity.this.getString(R.string.mapbox_plugins_place_picker_not_valid_selection), (int)0).show();
                    return;
                }
                PlacePickerActivity.this.placeSelected();
            }
        });
    }

    void placeSelected() {
        String json = this.carmenFeature.toJson();
        Intent returningIntent = new Intent();
        returningIntent.putExtra("com.mapbox.mapboxsdk.plugins.places.carmenfeat", json);
        returningIntent.putExtra("com.mapbox.mapboxsdk.plugins.places.cameraPosition", (Parcelable)this.mapboxMap.getCameraPosition());
        this.setResult(-1, returningIntent);
        this.finish();
    }

    protected void onStart() {
        super.onStart();
        this.mapView.onStart();
    }

    protected void onResume() {
        super.onResume();
        this.mapView.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mapView.onPause();
    }

    protected void onStop() {
        super.onStop();
        this.mapView.onStop();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mapView.onSaveInstanceState(outState);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mapView.onDestroy();
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.mapView.onLowMemory();
    }
}

