/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.picker.ui;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.mapboxsdk.places.R;
import com.mapbox.mapboxsdk.plugins.places.common.utils.GeocodingUtils;

public class CurrentPlaceSelectionBottomSheet
extends CoordinatorLayout {
    private BottomSheetBehavior bottomSheetBehavior;
    private CoordinatorLayout rootView;
    private TextView placeNameTextView;
    private TextView placeAddressTextView;
    private ProgressBar placeProgressBar;

    public CurrentPlaceSelectionBottomSheet(Context context) {
        this(context, null);
    }

    public CurrentPlaceSelectionBottomSheet(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public CurrentPlaceSelectionBottomSheet(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.rootView = (CoordinatorLayout)CurrentPlaceSelectionBottomSheet.inflate((Context)context, (int)R.layout.mapbox_view_bottom_sheet_container, (ViewGroup)this);
        this.bottomSheetBehavior = BottomSheetBehavior.from((View)this.rootView.findViewById(R.id.root_bottom_sheet));
        this.bottomSheetBehavior.setHideable(true);
        this.bottomSheetBehavior.setState(5);
        this.bindViews();
    }

    private void bindViews() {
        this.placeNameTextView = (TextView)this.findViewById(R.id.text_view_place_name);
        this.placeAddressTextView = (TextView)this.findViewById(R.id.text_view_place_address);
        this.placeProgressBar = (ProgressBar)this.findViewById(R.id.progress_bar_place);
    }

    public void setPlaceDetails(@Nullable CarmenFeature carmenFeature) {
        if (!this.isShowing()) {
            this.toggleBottomSheet();
        }
        if (carmenFeature == null) {
            this.placeNameTextView.setText((CharSequence)"");
            this.placeAddressTextView.setText((CharSequence)"");
            this.placeProgressBar.setVisibility(0);
            return;
        }
        this.placeProgressBar.setVisibility(4);
        this.placeNameTextView.setText((CharSequence)(carmenFeature.text() == null ? "Dropped Pin" : carmenFeature.text()));
        this.placeAddressTextView.setText((CharSequence)GeocodingUtils.removeNameFromAddress(carmenFeature));
    }

    public void dismissPlaceDetails() {
        this.toggleBottomSheet();
    }

    public boolean isShowing() {
        return this.bottomSheetBehavior.getState() != 5;
    }

    private void toggleBottomSheet() {
        this.bottomSheetBehavior.setPeekHeight(this.rootView.findViewById(R.id.bottom_sheet_header).getHeight());
        this.bottomSheetBehavior.setHideable(this.isShowing());
        this.bottomSheetBehavior.setState(this.isShowing() ? 5 : 4);
    }
}

