/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete.viewmodel;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.ViewModel;
import android.arch.lifecycle.ViewModelProvider;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.geocoding.v5.MapboxGeocoding;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.api.geocoding.v5.models.GeocodingResponse;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.DataRepository;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.SearchHistoryDatabase;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.entity.SearchHistoryEntity;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.model.PlaceOptions;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import timber.log.Timber;

public class PlaceAutocompleteViewModel
extends AndroidViewModel
implements Callback<GeocodingResponse> {
    public final MutableLiveData<GeocodingResponse> geocodingLiveData;
    private MapboxGeocoding.Builder geocoderBuilder;
    private PlaceOptions placeOptions;

    PlaceAutocompleteViewModel(@NonNull Application application, @NonNull PlaceOptions placeOptions) {
        super(application);
        this.placeOptions = placeOptions;
        this.geocodingLiveData = new MutableLiveData();
    }

    public void buildGeocodingRequest(String accessToken) {
        String bbox;
        String countriesJson;
        String typeJson;
        String languageJson;
        this.geocoderBuilder = MapboxGeocoding.builder().autocomplete(Boolean.valueOf(true));
        this.geocoderBuilder.accessToken(accessToken);
        this.geocoderBuilder.limit(this.placeOptions.limit());
        Point proximityPoint = this.placeOptions.proximity();
        if (proximityPoint != null) {
            this.geocoderBuilder.proximity(proximityPoint);
        }
        if ((languageJson = this.placeOptions.language()) != null) {
            this.geocoderBuilder.languages(languageJson);
        }
        if ((typeJson = this.placeOptions.geocodingTypes()) != null) {
            this.geocoderBuilder.geocodingTypes(new String[]{typeJson});
        }
        if ((countriesJson = this.placeOptions.country()) != null) {
            this.geocoderBuilder.country(countriesJson);
        }
        if ((bbox = this.placeOptions.bbox()) != null) {
            this.geocoderBuilder.bbox(bbox);
        }
    }

    public void onQueryChange(CharSequence sequence) {
        String query = sequence.toString();
        if (query.isEmpty()) {
            return;
        }
        if (this.geocoderBuilder == null) {
            throw new NullPointerException("An access token must be set before a geocoding query can be made.");
        }
        this.geocoderBuilder.query(query).build().enqueueCall((Callback)this);
    }

    public List<CarmenFeature> getFavoritePlaces() {
        List<String> serialized = this.placeOptions.injectedPlaces();
        ArrayList<CarmenFeature> favoriteFeatures = new ArrayList<CarmenFeature>();
        if (serialized == null || serialized.isEmpty()) {
            return favoriteFeatures;
        }
        for (String serializedCarmenFeature : serialized) {
            favoriteFeatures.add(CarmenFeature.fromJson((String)serializedCarmenFeature));
        }
        return favoriteFeatures;
    }

    public void onResponse(@NonNull Call<GeocodingResponse> call, @NonNull Response<GeocodingResponse> response) {
        if (response.isSuccessful()) {
            this.geocodingLiveData.setValue(response.body());
        } else {
            this.geocodingLiveData.setValue(null);
        }
    }

    public void onFailure(@NonNull Call<GeocodingResponse> call, @NonNull Throwable throwable) {
        Timber.e((Throwable)throwable);
        this.geocodingLiveData.setValue(null);
    }

    public SearchHistoryDatabase getDatabase() {
        return SearchHistoryDatabase.getInstance(this.getApplication().getApplicationContext());
    }

    public void saveCarmenFeatureToDatabase(CarmenFeature carmenFeature) {
        if (carmenFeature.properties().has("com.mapbox.mapboxsdk.plugins.places.savedcarmenfeat")) {
            return;
        }
        SearchHistoryEntity searchHistory = new SearchHistoryEntity(carmenFeature.id(), carmenFeature);
        DataRepository.getInstance(this.getDatabase()).addSearchHistoryEntity(searchHistory);
    }

    public static class Factory
    extends ViewModelProvider.NewInstanceFactory {
        private final Application application;
        private final PlaceOptions placeOptions;

        public Factory(@NonNull Application application, @NonNull PlaceOptions placeOptions) {
            this.application = application;
            this.placeOptions = placeOptions;
        }

        @NonNull
        public <T extends ViewModel> T create(@Nullable Class<T> modelClass) {
            return (T)((Object)new PlaceAutocompleteViewModel(this.application, this.placeOptions));
        }
    }
}

