/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete.ui;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ScrollView;
import android.widget.Toast;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.api.geocoding.v5.models.GeocodingResponse;
import com.mapbox.mapboxsdk.places.R;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.DataRepository;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.entity.SearchHistoryEntity;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.model.PlaceOptions;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.PlaceSelectionListener;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.ResultClickCallback;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.ResultView;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.SearchView;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.viewmodel.PlaceAutocompleteViewModel;
import com.mapbox.mapboxsdk.plugins.places.common.utils.KeyboardUtils;
import java.util.List;
import timber.log.Timber;

public class PlaceAutocompleteFragment
extends Fragment
implements ResultClickCallback,
SearchView.QueryListener,
SearchView.BackButtonListener,
ViewTreeObserver.OnScrollChangedListener {
    public static final String TAG = "PlaceAutocompleteFragment";
    private PlaceSelectionListener placeSelectionListener;
    private PlaceAutocompleteViewModel viewModel;
    private ResultView searchHistoryView;
    private ResultView searchResultView;
    private ScrollView resultScrollView;
    private View offlineResultView;
    private PlaceOptions placeOptions;
    private ResultView starredView;
    private SearchView searchView;
    private View dropShadowView;
    private String accessToken;
    private View rootView;
    private int mode;

    public static PlaceAutocompleteFragment newInstance(@NonNull String accessToken) {
        PlaceAutocompleteFragment fragment = new PlaceAutocompleteFragment();
        Bundle bundle = new Bundle();
        bundle.putString("com.mapbox.mapboxsdk.plugins.places.accessToken", accessToken);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static PlaceAutocompleteFragment newInstance(@NonNull String accessToken, @Nullable PlaceOptions placeOptions) {
        PlaceAutocompleteFragment fragment = new PlaceAutocompleteFragment();
        Bundle bundle = new Bundle();
        bundle.putString("com.mapbox.mapboxsdk.plugins.places.accessToken", accessToken);
        bundle.putParcelable("com.mapbox.mapboxsdk.plugins.places.placeOptions", (Parcelable)placeOptions);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Bundle bundle = this.getArguments();
        this.accessToken = bundle.getString("com.mapbox.mapboxsdk.plugins.places.accessToken");
        this.placeOptions = (PlaceOptions)bundle.getParcelable("com.mapbox.mapboxsdk.plugins.places.placeOptions");
        if (this.placeOptions == null) {
            this.placeOptions = PlaceOptions.builder().build();
        }
        this.mode = this.placeOptions.viewMode();
        this.rootView = inflater.inflate(this.mode == 2 ? R.layout.mapbox_fragment_autocomplete_card : R.layout.mapbox_fragment_autocomplete_full, container, false);
        this.bindViews();
        this.bindClickListeners();
        return this.rootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.resultScrollView.getViewTreeObserver().addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        this.styleView();
    }

    private void styleView() {
        if (this.placeOptions != null && this.rootView != null) {
            this.rootView.setBackgroundColor(this.placeOptions.backgroundColor());
            View toolbar = this.rootView.findViewById(R.id.toolbar);
            if (toolbar != null) {
                toolbar.setBackgroundColor(this.placeOptions.toolbarColor());
            }
            this.searchView = (SearchView)this.rootView.findViewById(R.id.searchView);
            this.searchView.setHint(this.placeOptions.hint() == null ? this.getString(R.string.mapbox_plugins_autocomplete_search_hint) : this.placeOptions.hint());
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        PlaceAutocompleteViewModel.Factory factory = new PlaceAutocompleteViewModel.Factory(this.getActivity().getApplication(), this.placeOptions);
        this.viewModel = (PlaceAutocompleteViewModel)ViewModelProviders.of((Fragment)this, (ViewModelProvider.Factory)factory).get(PlaceAutocompleteViewModel.class);
        if (this.accessToken != null) {
            this.viewModel.buildGeocodingRequest(this.accessToken);
        }
        this.updateFavoritePlacesView();
        this.subscribe();
    }

    public void onScrollChanged() {
        if (this.resultScrollView != null) {
            if (this.resultScrollView.getScrollY() != 0) {
                KeyboardUtils.hideKeyboard((View)this.resultScrollView);
            }
            if (this.mode == 1) {
                return;
            }
            this.dropShadowView.setVisibility(this.resultScrollView.canScrollVertically(-1) ? 0 : 4);
        }
    }

    @Override
    public void onQueryChange(CharSequence charSequence) {
        this.viewModel.onQueryChange(charSequence);
        if (charSequence.length() <= 0) {
            this.searchResultView.getResultsList().clear();
            this.searchResultView.setVisibility(this.searchResultView.getResultsList().isEmpty() ? 8 : 0);
            this.searchResultView.notifyDataSetChanged();
        }
    }

    @Override
    public void onClick(CarmenFeature carmenFeature) {
        this.viewModel.saveCarmenFeatureToDatabase(carmenFeature);
        if (this.placeSelectionListener != null) {
            this.placeSelectionListener.onPlaceSelected(carmenFeature);
        }
    }

    public void onDestroyView() {
        if (this.resultScrollView != null) {
            this.resultScrollView.getViewTreeObserver().removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        }
        this.placeSelectionListener = null;
        super.onDestroyView();
    }

    @Override
    public void onBackButtonPress() {
        if (this.placeSelectionListener != null) {
            this.placeSelectionListener.onCancel();
        }
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener listener) {
        this.placeSelectionListener = listener;
    }

    private void bindClickListeners() {
        this.searchHistoryView.setOnItemClickListener(this);
        this.searchResultView.setOnItemClickListener(this);
        this.starredView.setOnItemClickListener(this);
        this.searchView.setBackButtonListener(this);
        this.searchView.setQueryListener(this);
    }

    private void bindViews() {
        this.searchHistoryView = (ResultView)this.rootView.findViewById(R.id.searchHistoryResultsView);
        this.resultScrollView = (ScrollView)this.rootView.findViewById(R.id.scroll_view_results);
        this.offlineResultView = this.rootView.findViewById(R.id.offlineResultView);
        this.searchResultView = (ResultView)this.rootView.findViewById(R.id.searchResultView);
        this.dropShadowView = this.rootView.findViewById(R.id.scroll_drop_shadow);
        this.starredView = (ResultView)this.rootView.findViewById(R.id.favoriteResultView);
        this.searchView = (SearchView)this.rootView.findViewById(R.id.searchView);
        this.rootView = this.rootView.findViewById(R.id.root_layout);
    }

    void updateSearchHistoryView(@Nullable List<SearchHistoryEntity> searchHistoryEntities) {
        this.searchHistoryView.getResultsList().clear();
        if (searchHistoryEntities != null) {
            for (SearchHistoryEntity entity : searchHistoryEntities) {
                this.searchHistoryView.getResultsList().add(entity.getCarmenFeature());
            }
        }
        this.searchHistoryView.notifyDataSetChanged();
        this.searchHistoryView.setVisibility(this.searchHistoryView.getResultsList().isEmpty() ? 8 : 0);
    }

    void updateSearchResultView(@Nullable GeocodingResponse response) {
        this.searchResultView.getResultsList().clear();
        this.searchResultView.getResultsList().addAll(response.features());
        this.searchResultView.setVisibility(this.searchResultView.getResultsList().isEmpty() ? 8 : 0);
        this.searchResultView.notifyDataSetChanged();
        if (this.offlineResultView.getVisibility() == 0) {
            this.offlineResultView.setVisibility(8);
        }
    }

    private void updateFavoritePlacesView() {
        List<CarmenFeature> favoriteFeatures = this.viewModel.getFavoritePlaces();
        this.starredView.getResultsList().addAll(favoriteFeatures);
    }

    void showOfflineView() {
        this.searchResultView.setVisibility(8);
        if (this.offlineResultView.getVisibility() == 0) {
            Toast.makeText((Context)this.rootView.getContext(), (CharSequence)this.getString(R.string.mapbox_snackbar_offline_message), (int)1).show();
        } else {
            this.offlineResultView.setVisibility(0);
        }
    }

    private void subscribe() {
        this.viewModel.geocodingLiveData.observe((LifecycleOwner)this, (Observer)new Observer<GeocodingResponse>(){

            public void onChanged(@Nullable GeocodingResponse geocodingResponse) {
                if (geocodingResponse != null) {
                    PlaceAutocompleteFragment.this.updateSearchResultView(geocodingResponse);
                } else {
                    Timber.v((String)"Response is null, likely due to no internet connection.", (Object[])new Object[0]);
                    PlaceAutocompleteFragment.this.showOfflineView();
                }
            }
        });
        DataRepository.getInstance(this.viewModel.getDatabase()).getSearchHistory().observe((LifecycleOwner)this, (Observer)new Observer<List<SearchHistoryEntity>>(){

            public void onChanged(@Nullable List<SearchHistoryEntity> searchHistoryEntities) {
                PlaceAutocompleteFragment.this.updateSearchHistoryView(searchHistoryEntities);
            }
        });
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

