/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete.data.dao;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.converter.CarmenFeatureConverter;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.dao.SearchHistoryDao;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.entity.SearchHistoryEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SearchHistoryDao_Impl
implements SearchHistoryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfSearchHistoryEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllEntries;

    public SearchHistoryDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSearchHistoryEntity = new EntityInsertionAdapter<SearchHistoryEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `searchhistory`(`placeId`,`carmen_feature`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SearchHistoryEntity value) {
                if (value.getPlaceId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPlaceId());
                }
                String _tmp = CarmenFeatureConverter.fromCarmenFeature(value.getCarmenFeature());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
            }
        };
        this.__preparedStmtOfDeleteAllEntries = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM searchhistory";
                return "DELETE FROM searchhistory";
            }
        };
    }

    @Override
    public void insert(SearchHistoryEntity searchHistory) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSearchHistoryEntity.insert((Object)searchHistory);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAllEntries() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllEntries.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllEntries.release(_stmt);
        }
    }

    @Override
    public LiveData<List<SearchHistoryEntity>> getAll() {
        String _sql = "SELECT * FROM searchhistory";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM searchhistory", (int)0);
        return new ComputableLiveData<List<SearchHistoryEntity>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<SearchHistoryEntity> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("searchhistory", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    SearchHistoryDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = SearchHistoryDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfPlaceId = _cursor.getColumnIndexOrThrow("placeId");
                    int _cursorIndexOfCarmenFeature = _cursor.getColumnIndexOrThrow("carmen_feature");
                    ArrayList<SearchHistoryEntity> _result = new ArrayList<SearchHistoryEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpPlaceId = _cursor.getString(_cursorIndexOfPlaceId);
                        String _tmp = _cursor.getString(_cursorIndexOfCarmenFeature);
                        CarmenFeature _tmpCarmenFeature = CarmenFeatureConverter.toCarmenFeature(_tmp);
                        SearchHistoryEntity _item = new SearchHistoryEntity(_tmpPlaceId, _tmpCarmenFeature);
                        _result.add(_item);
                    }
                    ArrayList<SearchHistoryEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }
}

