/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete.data;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.converter.CarmenFeatureConverter;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.dao.SearchHistoryDao;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.entity.SearchHistoryEntity;

@Database(entities={SearchHistoryEntity.class}, version=1)
@TypeConverters(value={CarmenFeatureConverter.class})
public abstract class SearchHistoryDatabase
extends RoomDatabase {
    private static final String DATABASE_NAME = "com.mapbox.mapboxsdk.plugins.places.database";
    private static SearchHistoryDatabase instance;
    private final MutableLiveData<Boolean> isDatabaseCreated = new MutableLiveData();

    public abstract SearchHistoryDao searchHistoryDao();

    public static SearchHistoryDatabase getInstance(Context context) {
        if (instance == null) {
            instance = SearchHistoryDatabase.buildDatabase(context.getApplicationContext());
            instance.updateDatabaseCreated(context.getApplicationContext());
        }
        return instance;
    }

    private static SearchHistoryDatabase buildDatabase(final Context appContext) {
        return (SearchHistoryDatabase)Room.databaseBuilder((Context)appContext, SearchHistoryDatabase.class, (String)DATABASE_NAME).addCallback(new RoomDatabase.Callback(){

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                super.onCreate(db);
                SearchHistoryDatabase database = SearchHistoryDatabase.getInstance(appContext);
                database.setDatabaseCreated();
            }
        }).build();
    }

    private void updateDatabaseCreated(Context context) {
        if (context.getDatabasePath(DATABASE_NAME).exists()) {
            this.setDatabaseCreated();
        }
    }

    private void setDatabaseCreated() {
        this.isDatabaseCreated.postValue((Object)true);
    }

    public static void insertData(SearchHistoryDatabase database, SearchHistoryEntity searchHistory) {
        new DatabaseTask(database, searchHistory).execute(new Void[0]);
    }

    public static void deleteAllData(SearchHistoryDatabase database) {
        new DatabaseTask(database, true).execute(new Void[0]);
    }

    public final LiveData<Boolean> getDatabaseCreated() {
        return this.isDatabaseCreated;
    }

    private static class DatabaseTask
    extends AsyncTask<Void, Void, Void> {
        private final SearchHistoryDatabase database;
        private SearchHistoryEntity searchHistory;
        private boolean delete;

        DatabaseTask(SearchHistoryDatabase database, boolean delete) {
            this.delete = delete;
            this.database = database;
        }

        DatabaseTask(SearchHistoryDatabase database, SearchHistoryEntity searchHistory) {
            this.searchHistory = searchHistory;
            this.database = database;
        }

        protected Void doInBackground(Void ... voids) {
            if (this.delete) {
                this.database.searchHistoryDao().deleteAllEntries();
            } else {
                this.database.searchHistoryDao().insert(this.searchHistory);
            }
            return null;
        }
    }
}

