/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.markerview;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.plugins.markerview.MarkerView;
import java.util.ArrayList;
import java.util.List;

public class MarkerViewManager
implements MapView.OnDidFinishRenderingFrameListener {
    private final MapView mapView;
    private final MapboxMap mapboxMap;
    private final List<MarkerView> markers = new ArrayList<MarkerView>();
    private boolean initialised;

    public MarkerViewManager(MapView mapView, MapboxMap mapboxMap) {
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
    }

    @UiThread
    public void onDestroy() {
        this.markers.clear();
        this.mapView.removeOnDidFinishRenderingFrameListener((MapView.OnDidFinishRenderingFrameListener)this);
        this.initialised = false;
    }

    @UiThread
    public void addMarker(@NonNull MarkerView markerView) {
        if (this.mapView.isDestroyed() || this.markers.contains(markerView)) {
            return;
        }
        if (!this.initialised) {
            this.initialised = true;
            this.mapView.addOnDidFinishRenderingFrameListener((MapView.OnDidFinishRenderingFrameListener)this);
        }
        markerView.setProjection(this.mapboxMap.getProjection());
        this.mapView.addView(markerView.getView());
        this.markers.add(markerView);
    }

    @UiThread
    public void removeMarker(@NonNull MarkerView markerView) {
        if (this.mapView.isDestroyed() || !this.markers.contains(markerView)) {
            return;
        }
        this.mapView.removeView(markerView.getView());
        this.markers.remove(markerView);
    }

    public void onDidFinishRenderingFrame(boolean fully) {
        if (fully) {
            this.update();
        }
    }

    private void update() {
        for (MarkerView marker : this.markers) {
            marker.update();
        }
    }
}

