/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.markerview;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.view.View;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;

public class MarkerView {
    private final View view;
    private LatLng latLng;
    private Projection projection;
    private OnPositionUpdateListener onPositionUpdateListener;

    public MarkerView(@NonNull LatLng latLng, @NonNull View view) {
        this.latLng = latLng;
        this.view = view;
    }

    public void setLatLng(@NonNull LatLng latLng) {
        this.latLng = latLng;
        this.update();
    }

    public void setOnPositionUpdateListener(OnPositionUpdateListener onPositionUpdateListener) {
        this.onPositionUpdateListener = onPositionUpdateListener;
    }

    void setProjection(Projection projection) {
        this.projection = projection;
    }

    View getView() {
        return this.view;
    }

    void update() {
        PointF point = this.projection.toScreenLocation(this.latLng);
        if (this.onPositionUpdateListener != null) {
            point = this.onPositionUpdateListener.onUpdate(point);
        }
        this.view.setX(point.x);
        this.view.setY(point.y);
    }

    public static interface OnPositionUpdateListener {
        public PointF onUpdate(PointF var1);
    }
}

