/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.locationlayer;

import android.os.Handler;
import com.mapbox.mapboxsdk.plugins.locationlayer.OnLocationStaleListener;

class StaleStateManager {
    private final OnLocationStaleListener innerOnLocationStaleListeners;
    private final Handler handler;
    private boolean isStale = true;
    private long delayTime;
    private Runnable staleStateRunnable = new Runnable(){

        @Override
        public void run() {
            StaleStateManager.this.isStale = true;
            StaleStateManager.this.innerOnLocationStaleListeners.onStaleStateChange(true);
        }
    };

    StaleStateManager(OnLocationStaleListener innerListener, long delayTime) {
        this.innerOnLocationStaleListeners = innerListener;
        this.delayTime = delayTime;
        this.handler = new Handler();
        this.innerOnLocationStaleListeners.onStaleStateChange(true);
    }

    boolean isStale() {
        return this.isStale;
    }

    void updateLatestLocationTime() {
        if (this.isStale) {
            this.isStale = false;
            this.innerOnLocationStaleListeners.onStaleStateChange(false);
        }
        this.postTheCallback();
    }

    void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
        this.postTheCallback();
    }

    void onStart() {
        if (!this.isStale) {
            this.postTheCallback();
        }
    }

    void onStop() {
        this.handler.removeCallbacksAndMessages(null);
    }

    private void postTheCallback() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.postDelayed(this.staleStateRunnable, this.delayTime);
    }
}

