/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.locationlayer;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import com.google.auto.value.AutoValue;
import com.mapbox.mapboxsdk.plugins.locationlayer.$AutoValue_LocationLayerOptions;
import com.mapbox.mapboxsdk.plugins.locationlayer.R;

@AutoValue
public abstract class LocationLayerOptions
implements Parcelable {
    private static final float ACCURACY_ALPHA_DEFAULT = 0.15f;
    private static final float MAX_ZOOM_DEFAULT = 18.0f;
    private static final float MIN_ZOOM_DEFAULT = 2.0f;
    private static final int[] PADDING_DEFAULT = new int[]{0, 0, 0, 0};
    private static final long STALE_STATE_DELAY_MS = 30000L;

    public static LocationLayerOptions createFromAttributes(@NonNull Context context, @StyleRes int styleRes) {
        TypedArray typedArray = context.obtainStyledAttributes(styleRes, R.styleable.mapbox_LocationLayer);
        Builder builder = LocationLayerOptions.builder();
        builder.foregroundDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationLayer_mapbox_foregroundDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationLayer_mapbox_foregroundTintColor)) {
            builder.foregroundTintColor(typedArray.getColor(R.styleable.mapbox_LocationLayer_mapbox_foregroundTintColor, -1));
        }
        builder.backgroundDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationLayer_mapbox_backgroundDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationLayer_mapbox_backgroundTintColor)) {
            builder.backgroundTintColor(typedArray.getColor(R.styleable.mapbox_LocationLayer_mapbox_backgroundTintColor, -1));
        }
        builder.foregroundDrawableStale(typedArray.getResourceId(R.styleable.mapbox_LocationLayer_mapbox_foregroundDrawableStale, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationLayer_mapbox_foregroundStaleTintColor)) {
            builder.foregroundStaleTintColor(typedArray.getColor(R.styleable.mapbox_LocationLayer_mapbox_foregroundStaleTintColor, -1));
        }
        builder.backgroundDrawableStale(typedArray.getResourceId(R.styleable.mapbox_LocationLayer_mapbox_backgroundDrawableStale, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationLayer_mapbox_backgroundStaleTintColor)) {
            builder.backgroundStaleTintColor(typedArray.getColor(R.styleable.mapbox_LocationLayer_mapbox_backgroundStaleTintColor, -1));
        }
        builder.bearingDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationLayer_mapbox_bearingDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationLayer_mapbox_bearingTintColor)) {
            builder.bearingTintColor(typedArray.getColor(R.styleable.mapbox_LocationLayer_mapbox_bearingTintColor, -1));
        }
        if (typedArray.hasValue(R.styleable.mapbox_LocationLayer_mapbox_enableStaleState)) {
            builder.enableStaleState(typedArray.getBoolean(R.styleable.mapbox_LocationLayer_mapbox_enableStaleState, true));
        }
        if (typedArray.hasValue(R.styleable.mapbox_LocationLayer_mapbox_staleStateTimeout)) {
            builder.staleStateTimeout(typedArray.getInteger(R.styleable.mapbox_LocationLayer_mapbox_staleStateTimeout, 30000));
        }
        builder.gpsDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationLayer_mapbox_navigationDrawable, -1));
        float elevation = typedArray.getDimension(R.styleable.mapbox_LocationLayer_mapbox_elevation, 0.0f);
        builder.accuracyColor(typedArray.getColor(R.styleable.mapbox_LocationLayer_mapbox_accuracyColor, -1));
        builder.accuracyAlpha(typedArray.getFloat(R.styleable.mapbox_LocationLayer_mapbox_accuracyAlpha, 0.15f));
        builder.elevation(elevation);
        builder.trackingInitialMoveThreshold(typedArray.getDimension(R.styleable.mapbox_LocationLayer_mapbox_trackingInitialMoveThreshold, context.getResources().getDimension(R.dimen.mapbox_locationLayerTrackingInitialMoveThreshold)));
        builder.trackingMultiFingerMoveThreshold(typedArray.getDimension(R.styleable.mapbox_LocationLayer_mapbox_trackingMultiFingerMoveThreshold, context.getResources().getDimension(R.dimen.mapbox_locationLayerTrackingMultiFingerMoveThreshold)));
        builder.padding(new int[]{typedArray.getInt(R.styleable.mapbox_LocationLayer_mapbox_iconPaddingLeft, 0), typedArray.getInt(R.styleable.mapbox_LocationLayer_mapbox_iconPaddingTop, 0), typedArray.getInt(R.styleable.mapbox_LocationLayer_mapbox_iconPaddingRight, 0), typedArray.getInt(R.styleable.mapbox_LocationLayer_mapbox_iconPaddingBottom, 0)});
        float maxZoom = typedArray.getFloat(R.styleable.mapbox_LocationLayer_mapbox_maxZoom, 18.0f);
        if (maxZoom < 0.0f || maxZoom > 25.5f) {
            throw new IllegalArgumentException("Max zoom value must be within 0.0 and 25.5");
        }
        float minZoom = typedArray.getFloat(R.styleable.mapbox_LocationLayer_mapbox_minZoom, 2.0f);
        if (minZoom < 0.0f || minZoom > 25.5f) {
            throw new IllegalArgumentException("Min zoom value must be within 0.0 and 25.5");
        }
        builder.maxZoom(maxZoom);
        builder.minZoom(minZoom);
        typedArray.recycle();
        return builder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder(Context context) {
        return LocationLayerOptions.createFromAttributes(context, R.style.mapbox_LocationLayer).toBuilder();
    }

    private static Builder builder() {
        return new $AutoValue_LocationLayerOptions.Builder().enableStaleState(true).staleStateTimeout(30000L).maxZoom(18.0).minZoom(2.0).padding(PADDING_DEFAULT);
    }

    public abstract float accuracyAlpha();

    @ColorInt
    public abstract int accuracyColor();

    @DrawableRes
    public abstract int backgroundDrawableStale();

    @DrawableRes
    public abstract int foregroundDrawableStale();

    @DrawableRes
    public abstract int gpsDrawable();

    @DrawableRes
    public abstract int foregroundDrawable();

    @DrawableRes
    public abstract int backgroundDrawable();

    @DrawableRes
    public abstract int bearingDrawable();

    @ColorInt
    @Nullable
    public abstract Integer bearingTintColor();

    @ColorInt
    @Nullable
    public abstract Integer foregroundTintColor();

    @ColorInt
    @Nullable
    public abstract Integer backgroundTintColor();

    @ColorInt
    @Nullable
    public abstract Integer foregroundStaleTintColor();

    @ColorInt
    @Nullable
    public abstract Integer backgroundStaleTintColor();

    @Dimension
    public abstract float elevation();

    public abstract boolean enableStaleState();

    public abstract long staleStateTimeout();

    public abstract int[] padding();

    public abstract double maxZoom();

    public abstract double minZoom();

    public abstract float trackingInitialMoveThreshold();

    public abstract float trackingMultiFingerMoveThreshold();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder accuracyAlpha(@FloatRange(from=0.0, to=1.0) float var1);

        public abstract Builder accuracyColor(@ColorInt int var1);

        public abstract Builder foregroundDrawableStale(@DrawableRes int var1);

        public abstract Builder foregroundStaleTintColor(@ColorInt Integer var1);

        public abstract Builder backgroundDrawableStale(@DrawableRes int var1);

        public abstract Builder backgroundStaleTintColor(@ColorInt Integer var1);

        public abstract Builder gpsDrawable(@DrawableRes int var1);

        public abstract Builder foregroundDrawable(@DrawableRes int var1);

        public abstract Builder backgroundDrawable(@DrawableRes int var1);

        public abstract Builder bearingDrawable(@DrawableRes int var1);

        public abstract Builder bearingTintColor(@ColorInt Integer var1);

        public abstract Builder foregroundTintColor(@ColorInt Integer var1);

        public abstract Builder backgroundTintColor(@ColorInt Integer var1);

        public abstract Builder elevation(@Dimension float var1);

        public abstract Builder enableStaleState(boolean var1);

        public abstract Builder staleStateTimeout(long var1);

        public abstract Builder padding(int[] var1);

        public abstract Builder maxZoom(@FloatRange(from=0.0, to=25.5) double var1);

        public abstract Builder minZoom(@FloatRange(from=0.0, to=25.5) double var1);

        public abstract Builder trackingInitialMoveThreshold(float var1);

        public abstract Builder trackingMultiFingerMoveThreshold(float var1);

        abstract LocationLayerOptions autoBuild();

        public LocationLayerOptions build() {
            LocationLayerOptions locationLayerOptions = this.autoBuild();
            if (locationLayerOptions.accuracyAlpha() < 0.0f || locationLayerOptions.accuracyAlpha() > 1.0f) {
                throw new IllegalArgumentException("Location layer accuracy alpha value must be between 0.0 and 1.0.");
            }
            if (locationLayerOptions.elevation() < 0.0f) {
                throw new IllegalArgumentException("Invalid shadow size " + locationLayerOptions.elevation() + ". Must be >= 0");
            }
            return locationLayerOptions;
        }
    }
}

