/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.locationlayer;

import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.location.Location;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.view.animation.LinearInterpolator;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.locationlayer.Utils;
import com.mapbox.mapboxsdk.plugins.locationlayer.camera.BearingAnimator;
import com.mapbox.mapboxsdk.plugins.locationlayer.camera.LatLngAnimator;
import java.util.ArrayList;
import java.util.List;

final class LocationLayerAnimator {
    private final List<OnLayerAnimationsValuesChangeListener> layerListeners = new ArrayList<OnLayerAnimationsValuesChangeListener>();
    private final List<OnCameraAnimationsValuesChangeListener> cameraListeners = new ArrayList<OnCameraAnimationsValuesChangeListener>();
    private LatLngAnimator layerLatLngAnimator;
    private BearingAnimator layerGpsBearingAnimator;
    private BearingAnimator layerCompassBearingAnimator;
    private LatLngAnimator cameraLatLngAnimator;
    private BearingAnimator cameraGpsBearingAnimator;
    private BearingAnimator cameraCompassBearingAnimator;
    private Location previousLocation;
    private float previousCompassBearing = -1.0f;
    private long locationUpdateTimestamp = -1L;
    private final ValueAnimator.AnimatorUpdateListener layerLatLngUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            for (OnLayerAnimationsValuesChangeListener listener : LocationLayerAnimator.this.layerListeners) {
                listener.onNewLatLngValue((LatLng)valueAnimator.getAnimatedValue());
            }
        }
    };
    private final ValueAnimator.AnimatorUpdateListener layerCompassBearingUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            for (OnLayerAnimationsValuesChangeListener listener : LocationLayerAnimator.this.layerListeners) {
                listener.onNewCompassBearingValue(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        }
    };
    private final ValueAnimator.AnimatorUpdateListener layerGpsBearingUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            for (OnLayerAnimationsValuesChangeListener listener : LocationLayerAnimator.this.layerListeners) {
                listener.onNewGpsBearingValue(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        }
    };
    private final ValueAnimator.AnimatorUpdateListener cameraLatLngUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            for (OnCameraAnimationsValuesChangeListener listener : LocationLayerAnimator.this.cameraListeners) {
                listener.onNewLatLngValue((LatLng)valueAnimator.getAnimatedValue());
            }
        }
    };
    private final ValueAnimator.AnimatorUpdateListener cameraCompassBearingUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            for (OnCameraAnimationsValuesChangeListener listener : LocationLayerAnimator.this.cameraListeners) {
                listener.onNewCompassBearingValue(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        }
    };
    private final ValueAnimator.AnimatorUpdateListener cameraGpsBearingUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            for (OnCameraAnimationsValuesChangeListener listener : LocationLayerAnimator.this.cameraListeners) {
                listener.onNewGpsBearingValue(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        }
    };

    LocationLayerAnimator() {
    }

    void addLayerListener(OnLayerAnimationsValuesChangeListener listener) {
        this.layerListeners.add(listener);
    }

    void removeLayerListener(OnLayerAnimationsValuesChangeListener listener) {
        this.layerListeners.remove(listener);
    }

    void addCameraListener(OnCameraAnimationsValuesChangeListener listener) {
        this.cameraListeners.add(listener);
    }

    void removeCameraListener(OnCameraAnimationsValuesChangeListener listener) {
        this.cameraListeners.remove(listener);
    }

    void feedNewLocation(@NonNull Location newLocation, @NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        if (this.previousLocation == null) {
            this.previousLocation = newLocation;
            this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
        }
        LatLng previousLayerLatLng = this.getPreviousLayerLatLng();
        float previousLayerBearing = this.getPreviousLayerGpsBearing();
        LatLng previousCameraLatLng = currentCameraPosition.target;
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        LatLng targetLatLng = new LatLng(newLocation);
        float targetLayerBearing = newLocation.getBearing();
        float targetCameraBearing = newLocation.getBearing();
        targetCameraBearing = this.checkGpsNorth(isGpsNorth, targetCameraBearing);
        this.updateLayerAnimators(previousLayerLatLng, targetLatLng, previousLayerBearing, targetLayerBearing);
        this.updateCameraAnimators(previousCameraLatLng, previousCameraBearing, targetLatLng, targetCameraBearing);
        this.playAllLocationAnimators(this.getAnimationDuration());
        this.previousLocation = newLocation;
    }

    void feedNewCompassBearing(float targetCompassBearing, @NonNull CameraPosition currentCameraPosition) {
        if (this.previousCompassBearing < 0.0f) {
            this.previousCompassBearing = targetCompassBearing;
        }
        float previousLayerBearing = this.getPreviousLayerCompassBearing();
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        this.updateCompassAnimators(targetCompassBearing, previousLayerBearing, previousCameraBearing);
        this.playCompassAnimators(500L);
        this.previousCompassBearing = targetCompassBearing;
    }

    void resetAllCameraAnimations(CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.resetCameraCompassAnimation(currentCameraPosition);
        this.resetCameraLocationAnimations(currentCameraPosition, isGpsNorth);
        this.playCameraAnimators(750L);
    }

    void cancelAllAnimations() {
        this.cancelLayerLocationAnimations();
        this.cancelLayerCompassAnimations();
        this.cancelCameraLocationAnimations();
        this.cancelCameraCompassAnimations();
    }

    private LatLng getPreviousLayerLatLng() {
        LatLng previousLatLng = this.layerLatLngAnimator != null ? (LatLng)this.layerLatLngAnimator.getAnimatedValue() : new LatLng(this.previousLocation);
        return previousLatLng;
    }

    private float getPreviousLayerGpsBearing() {
        float previousBearing = this.layerGpsBearingAnimator != null ? ((Float)this.layerGpsBearingAnimator.getAnimatedValue()).floatValue() : this.previousLocation.getBearing();
        return previousBearing;
    }

    private float getPreviousLayerCompassBearing() {
        float previousBearing = this.layerCompassBearingAnimator != null ? ((Float)this.layerCompassBearingAnimator.getAnimatedValue()).floatValue() : this.previousCompassBearing;
        return previousBearing;
    }

    private void updateLayerAnimators(LatLng previousLatLng, LatLng targetLatLng, float previousBearing, float targetBearing) {
        this.cancelLayerLocationAnimations();
        this.layerLatLngAnimator = new LatLngAnimator(previousLatLng, targetLatLng);
        float normalizedLayerBearing = Utils.shortestRotation(targetBearing, previousBearing);
        this.layerGpsBearingAnimator = new BearingAnimator(previousBearing, normalizedLayerBearing);
        this.layerLatLngAnimator.addUpdateListener(this.layerLatLngUpdateListener);
        this.layerGpsBearingAnimator.addUpdateListener(this.layerGpsBearingUpdateListener);
    }

    private void updateCameraAnimators(LatLng previousCameraLatLng, float previousCameraBearing, LatLng targetLatLng, float targetBearing) {
        this.cancelCameraLocationAnimations();
        this.cameraLatLngAnimator = new LatLngAnimator(previousCameraLatLng, targetLatLng);
        this.cameraLatLngAnimator.addUpdateListener(this.cameraLatLngUpdateListener);
        float normalizedCameraBearing = Utils.shortestRotation(targetBearing, previousCameraBearing);
        this.cameraGpsBearingAnimator = new BearingAnimator(previousCameraBearing, normalizedCameraBearing);
        this.cameraGpsBearingAnimator.addUpdateListener(this.cameraGpsBearingUpdateListener);
    }

    private long getAnimationDuration() {
        long previousUpdateTimeStamp = this.locationUpdateTimestamp;
        this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
        long animationDuration = previousUpdateTimeStamp == 0L ? 0L : (long)((float)(this.locationUpdateTimestamp - previousUpdateTimeStamp) * 1.1f);
        animationDuration = Math.min(animationDuration, 2000L);
        return animationDuration;
    }

    private float checkGpsNorth(boolean isGpsNorth, float targetCameraBearing) {
        if (isGpsNorth) {
            targetCameraBearing = 0.0f;
        }
        return targetCameraBearing;
    }

    private void playAllLocationAnimators(long duration) {
        ArrayList<ValueAnimator> locationAnimators = new ArrayList<ValueAnimator>();
        locationAnimators.add(this.layerLatLngAnimator);
        locationAnimators.add(this.layerGpsBearingAnimator);
        locationAnimators.add(this.cameraLatLngAnimator);
        locationAnimators.add(this.cameraGpsBearingAnimator);
        AnimatorSet locationAnimatorSet = new AnimatorSet();
        locationAnimatorSet.playTogether(locationAnimators);
        locationAnimatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        locationAnimatorSet.setDuration(duration);
        locationAnimatorSet.start();
    }

    private void playCameraAnimators(long duration) {
        ArrayList<ValueAnimator> locationAnimators = new ArrayList<ValueAnimator>();
        locationAnimators.add(this.cameraLatLngAnimator);
        locationAnimators.add(this.cameraGpsBearingAnimator);
        AnimatorSet locationAnimatorSet = new AnimatorSet();
        locationAnimatorSet.playTogether(locationAnimators);
        locationAnimatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        locationAnimatorSet.setDuration(duration);
        locationAnimatorSet.start();
    }

    private void updateCompassAnimators(float targetCompassBearing, float previousLayerBearing, float previousCameraBearing) {
        this.cancelLayerCompassAnimations();
        float normalizedLayerBearing = Utils.shortestRotation(targetCompassBearing, previousLayerBearing);
        this.layerCompassBearingAnimator = new BearingAnimator(previousLayerBearing, normalizedLayerBearing);
        this.layerCompassBearingAnimator.addUpdateListener(this.layerCompassBearingUpdateListener);
        this.cancelCameraCompassAnimations();
        float normalizedCameraBearing = Utils.shortestRotation(targetCompassBearing, previousCameraBearing);
        this.cameraCompassBearingAnimator = new BearingAnimator(previousCameraBearing, normalizedCameraBearing);
        this.cameraCompassBearingAnimator.addUpdateListener(this.cameraCompassBearingUpdateListener);
    }

    private void playCompassAnimators(long duration) {
        ArrayList<BearingAnimator> compassAnimators = new ArrayList<BearingAnimator>();
        compassAnimators.add(this.layerCompassBearingAnimator);
        compassAnimators.add(this.cameraCompassBearingAnimator);
        AnimatorSet compassAnimatorSet = new AnimatorSet();
        compassAnimatorSet.playTogether(compassAnimators);
        compassAnimatorSet.setDuration(duration);
        compassAnimatorSet.start();
    }

    private void cancelLayerLocationAnimations() {
        this.cancelLayerLatLngAnimations();
        this.cancelLayerGpsBearingAnimations();
    }

    private void cancelLayerLatLngAnimations() {
        if (this.layerLatLngAnimator != null) {
            this.layerLatLngAnimator.cancel();
            this.layerLatLngAnimator.removeAllUpdateListeners();
        }
    }

    private void cancelLayerGpsBearingAnimations() {
        if (this.layerGpsBearingAnimator != null) {
            this.layerGpsBearingAnimator.cancel();
            this.layerGpsBearingAnimator.removeAllUpdateListeners();
        }
    }

    private void cancelLayerCompassAnimations() {
        if (this.layerCompassBearingAnimator != null) {
            this.layerCompassBearingAnimator.cancel();
            this.layerCompassBearingAnimator.removeAllUpdateListeners();
        }
    }

    private void cancelCameraLocationAnimations() {
        this.cancelCameraLatLngAnimations();
        this.cancelCameraGpsBearingAnimations();
    }

    private void resetCameraLocationAnimations(CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.resetCameraLatLngAnimation(currentCameraPosition);
        this.resetCameraGpsBearingAnimation(currentCameraPosition, isGpsNorth);
    }

    private void cancelCameraLatLngAnimations() {
        if (this.cameraLatLngAnimator != null) {
            this.cameraLatLngAnimator.cancel();
            this.cameraLatLngAnimator.removeAllUpdateListeners();
        }
    }

    private void resetCameraLatLngAnimation(CameraPosition currentCameraPosition) {
        if (this.cameraLatLngAnimator == null) {
            return;
        }
        this.cancelCameraLatLngAnimations();
        LatLng currentTarget = this.cameraLatLngAnimator.getTarget();
        LatLng previousCameraTarget = currentCameraPosition.target;
        this.cameraLatLngAnimator = new LatLngAnimator(previousCameraTarget, currentTarget);
        this.cameraLatLngAnimator.addUpdateListener(this.cameraLatLngUpdateListener);
    }

    private void cancelCameraGpsBearingAnimations() {
        if (this.cameraGpsBearingAnimator != null) {
            this.cameraGpsBearingAnimator.cancel();
            this.cameraGpsBearingAnimator.removeAllUpdateListeners();
        }
    }

    private void resetCameraGpsBearingAnimation(CameraPosition currentCameraPosition, boolean isGpsNorth) {
        if (this.cameraGpsBearingAnimator == null) {
            return;
        }
        this.cancelCameraGpsBearingAnimations();
        float currentTargetBearing = this.cameraGpsBearingAnimator.getTargetBearing();
        currentTargetBearing = this.checkGpsNorth(isGpsNorth, currentTargetBearing);
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        float normalizedCameraBearing = Utils.shortestRotation(currentTargetBearing, previousCameraBearing);
        this.cameraGpsBearingAnimator = new BearingAnimator(previousCameraBearing, normalizedCameraBearing);
        this.cameraGpsBearingAnimator.addUpdateListener(this.cameraGpsBearingUpdateListener);
    }

    private void cancelCameraCompassAnimations() {
        if (this.cameraCompassBearingAnimator != null) {
            this.cameraCompassBearingAnimator.cancel();
            this.cameraCompassBearingAnimator.removeAllUpdateListeners();
        }
    }

    private void resetCameraCompassAnimation(CameraPosition currentCameraPosition) {
        if (this.cameraCompassBearingAnimator == null || this.cameraLatLngAnimator == null) {
            return;
        }
        this.cancelCameraCompassAnimations();
        float currentTargetBearing = this.cameraCompassBearingAnimator.getTargetBearing();
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        float normalizedCameraBearing = Utils.shortestRotation(currentTargetBearing, previousCameraBearing);
        this.cameraCompassBearingAnimator = new BearingAnimator(previousCameraBearing, normalizedCameraBearing);
        this.cameraCompassBearingAnimator.addUpdateListener(this.cameraCompassBearingUpdateListener);
    }

    static interface OnCameraAnimationsValuesChangeListener {
        public void onNewLatLngValue(LatLng var1);

        public void onNewGpsBearingValue(float var1);

        public void onNewCompassBearingValue(float var1);
    }

    static interface OnLayerAnimationsValuesChangeListener {
        public void onNewLatLngValue(LatLng var1);

        public void onNewGpsBearingValue(float var1);

        public void onNewCompassBearingValue(float var1);
    }
}

