/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.china.shift;

import android.app.Activity;
import android.location.Location;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.turf.TurfJoins;
import java.io.InputStream;
import java.util.Scanner;

public class ChinaBoundsChecker {
    public static boolean locationIsInChina(Activity activity, Location locationToQuery) {
        return ChinaBoundsChecker.pointIsInChina(activity, Point.fromLngLat((double)locationToQuery.getLongitude(), (double)locationToQuery.getLatitude()));
    }

    public static boolean latLngIsInChina(Activity activity, LatLng latLng) {
        return ChinaBoundsChecker.pointIsInChina(activity, Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pointIsInChina(Activity activity, Point pointToQuery) {
        try (Scanner scanner = null;){
            InputStream inputStream = activity.getAssets().open("china.geojson");
            scanner = new Scanner(inputStream).useDelimiter("\\A");
            FeatureCollection chinaPolygonFeatureCollection = FeatureCollection.fromJson((String)(scanner.hasNext() ? scanner.next() : ""));
            if (chinaPolygonFeatureCollection != null) {
                if (chinaPolygonFeatureCollection.features() != null && chinaPolygonFeatureCollection.features().size() > 0) {
                    if (((Feature)chinaPolygonFeatureCollection.features().get(0)).geometry() != null) {
                        Polygon chinaPolygon = (Polygon)((Feature)chinaPolygonFeatureCollection.features().get(0)).geometry();
                        if (chinaPolygon != null) {
                            boolean bl = TurfJoins.inside((Point)pointToQuery, (Polygon)chinaPolygon);
                            return bl;
                        }
                        Logger.e((String)"ShiftLocation", (String)String.format("Exception Loading GeoJSON: %s", String.format("Exception Loading GeoJSON: %s", "the China polygon is null")));
                    } else {
                        Logger.e((String)"ShiftLocation", (String)String.format("Exception Loading GeoJSON: %s", "the China polygon geometry is null"));
                    }
                } else {
                    Logger.e((String)"ShiftLocation", (String)String.format("Exception Loading GeoJSON: %s", "the China polygon FeatureCollection's list of features is null"));
                }
            } else {
                Logger.e((String)"ShiftLocation", (String)String.format("Exception Loading GeoJSON: %s", "the China polygon FeatureCollection is null"));
            }
        }
        return false;
    }
}

