/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.china.lint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UVariable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Lcom/mapbox/mapboxsdk/plugins/china/lint/WrongMapViewJavaUsageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "wrongMapViewDetector", "", "node", "Lcom/intellij/psi/PsiVariable;", "Issues", "china-lint"})
public final class WrongMapViewJavaUsageDetector
extends Detector
implements SourceCodeScanner {
    private static final String INCORRECT_MAPVIEW = "MapView";
    private static final String CORRECT_MAPVIEW = "ChinaMapView";
    private static final String REPORT_MESSAGE = "ChinaMapView should be used rather than MapView to ensure optimal performance.\n\u4f7f\u7528\u6027\u80fd\u66f4\u597d\u7684ChinaMapView\u6765\u4ee3\u66ffMapView";
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UVariable.class, ULocalVariable.class});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ WrongMapViewJavaUsageDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitVariable(@NotNull UVariable node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                this.this$0.wrongMapViewDetector((PsiVariable)node, this.$context);
            }

            public void visitLocalVariable(@NotNull ULocalVariable node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                this.this$0.wrongMapViewDetector((PsiVariable)node, this.$context);
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    public final void wrongMapViewDetector(@NotNull PsiVariable node, @NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiTypeElement psiTypeElement = node.getTypeElement();
        if (Intrinsics.areEqual((Object)(psiTypeElement != null ? psiTypeElement.getText() : null), (Object)INCORRECT_MAPVIEW)) {
            LintFix quickFix = this.fix().replace().name("Change to ChinaMapView").text(INCORRECT_MAPVIEW).with(CORRECT_MAPVIEW).build();
            PsiElement psiElement = node.getSourceElement();
            PsiElement psiElement2 = node.getSourceElement();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"node.sourceElement!!");
            context.report(ISSUE, psiElement, context.getLocation(psiElement2), REPORT_MESSAGE, quickFix);
        }
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(WrongMapViewJavaUsageDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE), new EnumSet[]{Scope.JAVA_FILE_SCOPE});
        ISSUE = Issue.Companion.create("NotChinaMapView", "ChinaMapView should be used rather than MapView", StringsKt.trimIndent((String)"\n       The China Plugin provides a `ChinaMapView` which should be used and replace \\\n       `MapView`. The reason for having a wrapper around the `MapView` class is to set default \\\n       values such as the map tile endpoints and styles.\n\n       If you **really** wish to use `MapView` instead of `ChinaMapView`, you'll need to suppress \\\n       this error and set the API basemap endpoint, styles, etc. to fit your application's best needs.\n       "), Category.USABILITY, 10, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://www.mapbox.com/android-docs/plugins/overview/china/#using-the-correct-objects");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/mapbox/mapboxsdk/plugins/china/lint/WrongMapViewJavaUsageDetector$Issues;", "", "()V", "CORRECT_MAPVIEW", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INCORRECT_MAPVIEW", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "REPORT_MESSAGE", "china-lint"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

