package com.mapbox.mapboxsdk.plugins.china.shift;

import android.location.Location;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * The class shifts location which is from device into the right mapping location on Mapbox map in china.
 */
public class ShiftLocation {

  private static ShiftForChina shiftForChina = new ShiftForChina();

  /**
   * This method transfers the location from devices to the shifted location.
   */
  public static Location shift(Location unshiftedLocationObject) {
    Location shiftedLocationObject = new Location(unshiftedLocationObject);
    String toJson = shiftForChina.shift(unshiftedLocationObject.getLongitude(),
      unshiftedLocationObject.getLatitude());
    try {
      JSONObject jsonObject = new JSONObject(toJson);
      shiftedLocationObject.setLongitude(jsonObject.getDouble("lon"));
      shiftedLocationObject.setLatitude(jsonObject.getDouble("lat"));
    } catch (JSONException jsonException) {
      jsonException.printStackTrace();
    }
    return shiftedLocationObject;
  }
}
