/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.china.shift;

import android.util.Log;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.shifter.CoordinateShifter;
import com.mapbox.mapboxsdk.plugins.china.shift.ShiftForChina;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ChinaCoordinateShifter
implements CoordinateShifter {
    private ShiftForChina shiftForChina = new ShiftForChina();

    public List<Double> shiftLonLat(double lon, double lat) {
        return this.shift(lon, lat);
    }

    public List<Double> shiftLonLatAlt(double lon, double lat, double altitude) {
        List<Double> shiftedLongLat = this.shift(lon, lat);
        shiftedLongLat.add(altitude);
        return shiftedLongLat;
    }

    public List<Double> unshiftPoint(Point shiftedPoint) {
        ArrayList<Double> shiftedCoordinates = new ArrayList<Double>(2);
        shiftedCoordinates.add(shiftedPoint.longitude());
        shiftedCoordinates.add(shiftedPoint.latitude());
        return shiftedCoordinates;
    }

    public List<Double> unshiftPoint(List<Double> shiftedCoordinates) {
        return shiftedCoordinates;
    }

    private List<Double> shift(double lon, double lat) {
        String toJson = this.shiftForChina.shift(lon, lat);
        ArrayList<Double> shiftedCoordinates = new ArrayList<Double>(3);
        try {
            JSONObject jsonObject = new JSONObject(toJson);
            double shiftedLon = jsonObject.getDouble("lon");
            double shiftedLat = jsonObject.getDouble("lat");
            shiftedCoordinates.add(shiftedLon);
            shiftedCoordinates.add(shiftedLat);
        }
        catch (JSONException jsonException) {
            shiftedCoordinates.add(lon);
            shiftedCoordinates.add(lat);
            jsonException.printStackTrace();
            Log.d((String)"ChinaCoordinateShifter", (String)"Can't convert shifted coordinate String to a JSONObject");
        }
        return shiftedCoordinates;
    }
}

