package com.mapbox.mapboxsdk.plugins.china.maps;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.SupportMapFragment;
import com.mapbox.mapboxsdk.utils.MapFragmentUtils;

import java.lang.reflect.Field;

public class ChinaSupportMapFragment extends SupportMapFragment {

  /**
   * Creates a default ChinaSupportMapFragment instance
   *
   * @return ChinaSupportMapFragment created
   */
  public static SupportMapFragment newInstance() {
    return new ChinaSupportMapFragment();
  }

  /**
   * Creates a ChinaSupportMapFragment instance
   *
   * @param mapboxMapOptions The configuration options to be used.
   * @return ChinaSupportMapFragment created.
   */
  public static ChinaSupportMapFragment newInstance(@Nullable MapboxMapOptions mapboxMapOptions) {
    ChinaSupportMapFragment mapFragment = new ChinaSupportMapFragment();
    mapFragment.setArguments(MapFragmentUtils.createFragmentArgs(mapboxMapOptions));
    return mapFragment;
  }

  @Override
  public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
    super.onCreateView(inflater, container, savedInstanceState);
    Context context = inflater.getContext();
    ChinaMapView map = new ChinaMapView(context, MapFragmentUtils.resolveArgs(context, getArguments()));

    try {
      Field privateStringField = SupportMapFragment.class
        .getDeclaredField("map");
      privateStringField.setAccessible(true);
      privateStringField.set(this, map);
    } catch (NoSuchFieldException exception) {
      exception.printStackTrace();
    } catch (IllegalAccessException exception) {
      exception.printStackTrace();
    }
    return map;
  }
}
