/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.china.constants;

import android.support.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ChinaStyle {
    public static final int MAPBOX_CHINA_STYLE_VERSION_1 = 1;
    public static final String MAPBOX_STREETS_CHINESE = "mapbox://styles/mapbox/streets-zh-v1";
    public static final String MAPBOX_LIGHT_CHINESE = "mapbox://styles/mapbox/light-zh-v1";
    public static final String MAPBOX_DARK_CHINESE = "mapbox://styles/mapbox/dark-zh-v1";

    private ChinaStyle() {
    }

    public static String specificChinaStyleVersion(@NonNull String chineseStyleUrl, int desiredVersion) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (chineseStyleUrl) {
            case "mapbox://styles/mapbox/streets-zh-v1": 
            case "mapbox://styles/mapbox/light-zh-v1": 
            case "mapbox://styles/mapbox/dark-zh-v1": {
                stringBuilder.append(chineseStyleUrl);
                stringBuilder.deleteCharAt(chineseStyleUrl.length() - 1);
                stringBuilder.append(String.valueOf(desiredVersion));
                break;
            }
            default: {
                stringBuilder.append(MAPBOX_STREETS_CHINESE);
                stringBuilder.deleteCharAt(MAPBOX_STREETS_CHINESE.length() - 1);
                stringBuilder.append(String.valueOf(desiredVersion));
            }
        }
        String mapStyleString = stringBuilder.toString();
        return mapStyleString.isEmpty() ? MAPBOX_STREETS_CHINESE : mapStyleString;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChinaStyleVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChinaStyleUrl {
    }
}

