/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.china.lint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/mapbox/mapboxsdk/plugins/china/lint/WrongStyleUrlDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "china-lint"})
public final class WrongStyleUrlDetector
extends Detector
implements SourceCodeScanner {
    private static final String REPORT_MESSAGE = "Use the provided China equivalent base map.";
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ WrongStyleUrlDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"setStyleUrl") || Intrinsics.areEqual((Object)node.getMethodName(), (Object)"setStyle")) {
                    Object object = ConstantEvaluator.evaluate((JavaContext)this.$context, (UElement)((UElement)node.getValueArguments().get(0)));
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    String style = (String)object;
                    LintFix.ReplaceStringBuilder quickFix = WrongStyleUrlDetector.access$fix(this.this$0).replace().name("Change to reference ChinaStyle");
                    if (StringsKt.contains$default((CharSequence)style, (CharSequence)"streets-v", (boolean)false, (int)2, null)) {
                        quickFix.text("Style.MAPBOX_STREETS").with("ChinaStyle.MAPBOX_STREETS_CHINESE");
                    } else if (StringsKt.contains$default((CharSequence)style, (CharSequence)"light-v", (boolean)false, (int)2, null)) {
                        quickFix.text("Style.LIGHT").with("ChinaStyle.MAPBOX_LIGHT_CHINESE");
                    } else if (StringsKt.contains$default((CharSequence)style, (CharSequence)"dark-v", (boolean)false, (int)2, null)) {
                        quickFix.text("Style.DARK").with("ChinaStyle.MAPBOX_DARK_CHINESE");
                    } else {
                        return;
                    }
                    this.$context.report(WrongStyleUrlDetector.ISSUE, (UElement)node, this.$context.getLocation((UElement)node), "Use the provided China equivalent base map.", quickFix.build());
                }
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(WrongStyleUrlDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE), new EnumSet[]{Scope.JAVA_FILE_SCOPE});
        ISSUE = Issue.Companion.create("useChinaStyleVersion", "The provided style you are using has an equivalent China version", StringsKt.trimIndent((String)"\n       Mapbox provides a set of default styles which can be referenced inside your app rather than \\\n       including the raw Style Url. For some styles, we have China alternatives which use the \\\n       `GCJ-02` coordinate system rather than the `WGS-84` system which you should use inside the \\\n       China region.\n\n       **Note**: If you are using one of the default China map styles provided, you'll also need \\\n       to make use of Shifting in order to ensure your map annotations match up with the base map. \\\n       Using the default provided map styles also means that when the base map style version is \\\n       updated, your app will automatically be bumped to the latest map style version when this \\\n       plugins updated.\n       "), Category.CORRECTNESS, 8, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://www.mapbox.com/android-docs/plugins/overview/china/#china-map-styles");
    }

    @NotNull
    public static final /* synthetic */ LintFix.Builder access$fix(WrongStyleUrlDetector $this) {
        return $this.fix();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/mapbox/mapboxsdk/plugins/china/lint/WrongStyleUrlDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "REPORT_MESSAGE", "", "china-lint"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

