/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.china.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/mapbox/mapboxsdk/plugins/china/lint/WrongMapViewXmlUsageDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableElements", "", "", "getApplicableFiles", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Issues", "china-lint"})
public final class WrongMapViewXmlUsageDetector
extends LayoutDetector {
    private static final String INCORRECT_MAPVIEW = "com.mapbox.mapboxsdk.maps.MapView";
    private static final String CORRECT_MAPVIEW = "com.mapbox.mapboxsdk.plugins.china.maps.ChinaMapView";
    private static final String REPORT_MESSAGE = "ChinaMapView should be used rather than MapView to ensure optimal performance.";
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    @NotNull
    public EnumSet<Scope> getApplicableFiles() {
        return Scope.RESOURCE_FILE_SCOPE;
    }

    @NotNull
    public List<String> getApplicableElements() {
        List list = LayoutDetector.ALL;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"LayoutDetector.ALL");
        return list;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String string = element.getTagName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.tagName");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)INCORRECT_MAPVIEW, (boolean)false, (int)2, null)) {
            LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace().name("Change to ChinaMapView").text(element.getTagName());
            String string2 = element.getTagName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.tagName");
            LintFix quickFix = replaceStringBuilder.with(StringsKt.replace$default((String)string2, (String)INCORRECT_MAPVIEW, (String)CORRECT_MAPVIEW, (boolean)false, (int)4, null)).build();
            context.report(ISSUE, (Node)element, context.getLocation((Node)element), REPORT_MESSAGE, quickFix);
        }
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(WrongMapViewXmlUsageDetector.class, EnumSet.of((Enum)Scope.RESOURCE_FILE), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE});
        ISSUE = Issue.Companion.create("NotChinaMapView", "ChinaMapView should be used rather than MapView", StringsKt.trimIndent((String)"\n      The China Plugin provides a `ChinaMapView` which should be used exclusively and replace \\\n      `MapView`. The reason for having a wrapper around the map view class is to set default \\\n       values such as endpoints and styles to specifically meet the needs inside the China region.\n\n       If you **really** wish to use `MapView` instead of `ChinaMapView` inside your class \\\n       you'll need to suppress this error and set the endpoint, style, etc. yourself to fit your \\\n       applications best needs.\n       "), Category.USABILITY, 10, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://www.mapbox.com/android-docs/plugins/overview/china/#using-the-correct-objects");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/mapbox/mapboxsdk/plugins/china/lint/WrongMapViewXmlUsageDetector$Issues;", "", "()V", "CORRECT_MAPVIEW", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INCORRECT_MAPVIEW", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "REPORT_MESSAGE", "china-lint"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

