package com.mapbox.mapboxsdk.plugins.china.maps;

import com.mapbox.mapboxsdk.constants.Style;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.plugins.china.BuildConfig;
import com.mapbox.mapboxsdk.plugins.china.constants.ChinaStyle;
import com.mapbox.mapboxsdk.plugins.china.constants.MapboxChinaConstants;

/**
 * set map base url and style for China map.
 */
public class MapboxMapChinaOptions extends MapboxMapOptions {

  public static MapboxMapOptions convert(MapboxMapOptions mapboxMapOptions) {
    // Skip setting the china values if using global flavor of plugin
    if (!BuildConfig.FLAVOR.contains(MapboxChinaConstants.FLAVOR_GLOBAL)) {
      mapboxMapOptions.apiBaseUrl(MapboxChinaConstants.BASE_API_URL);

      // validate if we need to provide the default mapbox streets chinese
      String style = mapboxMapOptions.getStyleUrl();
      if (style == null || style.isEmpty() || style.equals(Style.MAPBOX_STREETS)) {
        mapboxMapOptions.styleUrl(ChinaStyle.MAPBOX_STREETS_CHINESE);
      }
    }
    return mapboxMapOptions;
  }
}
