package com.mapbox.mapboxsdk.plugins.china.constants;

/**
 * Constants shared across classes.
 *
 * @since 0.4.0
 */
public class MapboxChinaConstants {

  private MapboxChinaConstants() {
    // No Instances
  }

  /**
   * The base URL for hitting the China server endpoints. In the China Flavor of this Plugin SDK,
   * all API request should be made using this base url.
   *
   * @since 0.4.0
   */
  public static final String BASE_API_URL = "https://api.mapbox.cn";

  /**
   * Defines the China flavor of this Plugin SDK.
   *
   * @since 0.4.0
   */
  public static final String FLAVOR_CHINA = "china";

  /**
   * Defines the Global flavor of this Plugin SDK.
   *
   * @since 0.4.0
   */
  public static final String FLAVOR_GLOBAL = "global";
}