package com.mapbox.mapboxsdk.plugins.china.constants;

import android.support.annotation.StringDef;

import com.mapbox.mapboxsdk.plugins.china.maps.ChinaMapView;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * <p>
 * Style provides URLs to several professional styles designed by Mapbox.
 * </p>
 * These styles are all ready to go in your app and will automatically switch from the
 * professionally designed Mapbox style of your choice to the Open Street Map base map depending on
 * the devices GeoIP location. To load one, pass it into {@link ChinaMapView#setStyleUrl(String)}
 *
 * @see ChinaMapView#setStyleUrl(String)
 * @since 0.4.0
 */
public class ChinaStyle {

  /**
   * Indicates the parameter accepts one of the values from Style. Using one of these
   * constants means your map style will always use the latest version and may change as we
   * improve the style
   *
   * @since 0.4.0
   */
  @StringDef( {MAPBOX_STREETS_CHINESE, MAPBOX_LIGHT_CHINESE, MAPBOX_DARK_CHINESE})
  @Retention(RetentionPolicy.SOURCE)
  public @interface ChinaStyleUrl {
  }

  private ChinaStyle() {
    // No Instances
  }

  // IMPORTANT: If you change any of these you also need to edit them in strings.xml

  /**
   * A complete basemap, perfect for incorporating your own data. Using this constant means your map
   * style will always use the latest version and may change as we improve
   * the style.
   *
   * @since 0.4.0
   */
  public static final String MAPBOX_STREETS_CHINESE = "mapbox://styles/mapbox/streets-zh-v1";

  /**
   * Subtle light backdrop for data visualizations. Using this constant means your map style will
   * always use the latest version and may change as we improve the style.
   *
   * @since 0.4.0
   */
  public static final String MAPBOX_LIGHT_CHINESE = "mapbox://styles/mapbox/light-zh-v1";

  /**
   * Subtle dark backdrop for data visualizations. Using this constant means your map style will
   * always use the latest version and may change as we improve the style.
   *
   * @since 0.4.0
   */
  public static final String MAPBOX_DARK_CHINESE = "mapbox://styles/mapbox/dark-zh-v1";
}


