package com.mapbox.mapboxsdk.plugins.china.maps;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.AttributeSet;

import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;

public class ChinaMapView extends MapView {

  @UiThread
  public ChinaMapView(@NonNull Context context) {
    super(context);
    initialize(context, new MapboxMapChinaOptions());
  }

  @UiThread
  public ChinaMapView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    initialize(context, MapboxMapChinaOptions.createFromAttributes(context, attrs));
  }

  @UiThread
  public ChinaMapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    initialize(context, MapboxMapChinaOptions.createFromAttributes(context, attrs));
  }

  @UiThread
  public ChinaMapView(@NonNull Context context, @Nullable MapboxMapChinaOptions options) {
    super(context);
    initialize(context, options == null ? new MapboxMapChinaOptions() : options);
  }

  private void initialize(Context context, MapboxMapOptions chinaOptions) {
    new MapView(context, chinaOptions);
  }
}
