package com.mapbox.mapboxsdk.plugins.china.services;

import com.mapbox.mapboxsdk.plugins.china.ChinaConstants;
import com.mapbox.services.api.optimizedtrips.v1.MapboxOptimizedTrips;

/**
 * The Mapbox Optimized Trips API returns a duration-optimized trip between the input coordinates. This is also known
 * as solving the Traveling Salesperson Problem. A typical use case for this API is planning the route for deliveries
 * in a city. Optimized trips can be retrieved for car driving, bicycling and walking or hiking.
 * <p>
 * Under normal plans, a maximum of 12 coordinates can be passed in at once at a maximum 60 requests per minute. For
 * higher volumes, reach out through our contact page.
 * <p>
 * Note that for under 10 coordinates, the returned results will be optimal. For 10 and more coordinates, the results
 * will be optimized approximations.
 * <p>
 * This class defaults to the China endpoint for all queries.
 * Set the Base Url into .cn.
 * @see <a href="https://en.wikipedia.org/wiki/Travelling_salesman_problem">Traveling Salesperson Problem</a>
 * @see <a href="https://www.mapbox.com/api-documentation/#optimized-trips">API documentation</a>
 * @since 2.1.0
 */
public class MapboxOptimizedTripsChina extends MapboxOptimizedTrips {
  public MapboxOptimizedTripsChina(MapboxOptimizedTrips.Builder builder) {
    super(builder);
    builder.setBaseUrl(ChinaConstants.BASE_API_URL);
  }
}
