package com.mapbox.mapboxsdk.plugins.china.map;

import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.plugins.china.BuildConfig;
import com.mapbox.mapboxsdk.plugins.china.ChinaConstants;

/**
 * set map base url and style for China map.
 */
public class MapboxMapChinaOptions extends MapboxMapOptions {
  public MapboxMapChinaOptions() {
    super();
    // Skip setting the china values if using global flavor of plugin
    if (BuildConfig.FLAVOR.contains(ChinaConstants.FLAVOR_GLBOAL)) {
      return;
    }
    apiBaseUrl(ChinaConstants.BASE_API_URL);
    styleUrl(ChinaConstants.STYLE_CN_URL);
  }
}
